                                Boot kernelu 2.4

Vytvoreni jadra

   Co se provadi, kdyz se spusti make bzImage

   Standardnim prekladacem jazyka C a assembleru cc(1) respektive as(1)  jsou
   vsechny soubory .c a .S prelozeny  do modulu .o formatu ELF pripadne  jsou
   dale jsou z nich vytvoreny knihovni archivu .a s pomoci ar(1) .

    1. Probehne normalni staticke slinkovani vsech potrebnych souboru .o a .a
       do souboru vmlinux (na architekture x86 je to 32-bitovy LSB ELF).
    2. Prikazem nm vmlinux, je (po nezbytne redukci) vytvorena mapa
       systemovych symbolu jadra System.map .
    3. Ze souboru arch/i386/boot/bootsect.S se vytvori assemblerovy zdroj
       zavadece pro bzImage, ten se prelozi a vysledny modul je po zkraceni o
       hlavicky ELF formatu ulozen jako binarni zavadec bbootsect .
    4. Podobne, prekladem a naslednym zkracenim o hlavicky, je ze souboru
       setup.S a video.S vytvoren soubor bsetup.
    5. Do adresare adresari arch/i386/boot/compressed se prekopiruje soubor
       vmlinux, ktery se zbavi sekci .note a .comment z ELF hlavicky,
       upraveny soubor je pak zkomprimovan pomoci gzip(1) a preveden na
       relokovatelny ELF piggy.o.
    6. Soubor piggy.o je slinkovan s dekompresnimi rutinami v head.o a misc.o
       do souboru bvmlinux .
    7. Soubor bvmlinux je opet zbaven sekci .note a .comment z ELF hlavicky a
       ulozen do bvmlinux.out.
    8. S pomoci tools/build jsou (za sebou) spojeny bbootsect, bsetup a
       compressed/bvmlinux.out do vysledneho bzImage. Do bootsektoru jsou
       take zapsany nektere informace zavadece, nicmene je mozne je pozdeji
       zmenit pomoci prikazu rdev(8).

Bootovani

     * Po privedeni napeti a startu hodinoveho taktu, se na sbernici ustali
       signal #POWERGOOD. Provede se reset CPU a nastartovani 8086 realneho
       rezimu. Jsou vynulovany vsechny segmentove registry, krome kodoveho,
       ktery je spolu s registrem %ip nastaven na adresu
       0xFFFF0000:0x0000FFF0, kde je v ROM ulozen programovy kod BIOS Power
       On Self Testu.
     * Provede se programovy kod BIOS POST (preruseni jsou zakazana), Adresa
       tabulky vektoru preruseni (IVT) je inicializovana na 0.
     * Na viceprocesorovem systemu je garantovano, ze procedurami BIOSu a do
       nasledneho procesu zavadeni systemu projde jen jediny procesor - tzv.
       boot procesor.
     * Do registru %dl je BIOSem nastaveno cislo zarizeni, ze ktereho se
       provede zavedeni systemu. Vyvolani int 0x19 provede nahrani nulte
       stopy, prvniho sektoru bootovaciho zarizeni na fyzickou adresu
       0x7C00:0000.

  Bootsektor

   Vetsina dnesnich systemu pouziva  bootloader , pokud  na nich bezi  Linux,
   pak nejcasteji LILO (LInux Loader), nebo Grub. Linux lze ale zavest i  bez
   asistence  takovych   programu  -   napriklad  tak,   ze  linuxove   jadro
   nakopirujeme na disketu tak, aby  se cast bbootsect jadra bzImage  dostala
   na nultou  stopu,  prvni  sektor  bootovaciho  zarizeni.  (cat  bzImage  >
   /dev/fd0).

   Vzapeti se na fyzicke  adrese 0x7C00 (dekadicky  31744) se zacne  provadet
   programovy kod zavadece Linuxu arch/i386/boot/bootsect.S

   movw    $BOOTSEG, %ax
   movw    %ax, %ds
   movw    $INITSEG, %ax
   movw    %ax, %es
   movw    $256, %cx
   subw    %si, %si
   subw    %di, %di
   cld
   rep
   movsw
   ljmp    $INITSEG, $go
  
   go:     movw    $0x4000-12, %di         # 0x4000 is an arbitrary value >=
                                           # length of bootsect + length of
                                           # setup + room for stack
                                           # 12 is disk parm size.
   movw    %ax, %ds                        # ax and es already contain INITSEG
   movw    %ax, %ss
   movw    %di, %sp                        # put stack at INITSEG:0x4000-12.

   pouzite konstanty jsou definovane v include/asm/boot.h jsou

   SETUPSECTS      = 4                     /* default nr of setup-sectors */
   BOOTSEG         = 0x07C0                /* original address of boot-sector */
   INITSEG         = DEF_INITSEG           /* we move boot here - out of the way */
   SETUPSEG        = DEF_SETUPSEG          /* setup starts here */
   SYSSEG          = DEF_SYSSEG            /* system loaded at 0x10000 (65536) */
   SYSSIZE         = DEF_SYSSIZE           /* system size: # of 16-byte clicks */
   /* to be loaded */
   #define DEF_INITSEG     0x9000
   #define DEF_SYSSEG      0x1000
   #define DEF_SETUPSEG    0x9020
   #define DEF_SYSSIZE     0x7F00

   Tedy, prvni cast programoveho kodu zkopiruje sebe sama do vyssi pameti (na
   adresu 0x9000:0 - tedy zhruba 580Kb  od zacatku pameti - puvodni  0x07C0:0
   je nevyhodne, protoze sidli "uprostred" pameti, a jadro by se nikam  kolem
   toho neveslo).

   Zbytek instrukci za $go pripravuje  dostatecny zasobnik pro rutiny,  ktere
   nahraji a spusti programovy kod setup.S (proto je potreba pri zmenach kodu
   setupu davat pozor, aby jeho programovy  kod + zasobnik potrebny pro  jeho
   beh nebyl mimo meze stanovene konstantami v bootsektoru). Dalsi cast  kodu
   zavadece je spis technicka zalezitost - upravuje tabulky BIOSu, aby  cteni
   dat pomoci jeho standardnich sluzeb nemuselo probihat po jednom sektoru  a
   nacte na fyzickou  adresu $INITSEG:0x0200 (tedy  tesne "za"  prekopirovany
   bootsector) programovy kod setup.S :

 load_setup:
   xorb    %ah, %ah                # reset FDC
   xorb    %dl, %dl
   int     $0x13
   xorw    %dx, %dx                # drive 0, head 0
   movb    $0x02, %cl              # sector 2, track 0
   movw    $0x0200, %bx            # address = 512, in INITSEG
   movb    $0x02, %ah              # service 2, "read sector(s)"
   movb    setup_sects, %al        # (assume all on head 0, track 0)
   int     $0x13                   # read it
   jnc     ok_load_setup           # ok - continue
  
   pushw   %ax                     # dump error code
   call    print_nl
   movw    %sp, %bp
   call    print_hex
   popw    %ax
   jmp     load_setup

   Pokud se cteni sektoru z nejakeho  duvodu (vadny HW) nepovede, provadi  se
   cteni v cyklu znova (proc?)

   Zbytek programoveho kodu bootsektoru  se postara o nahrati  komprimovaneho
   bzImage na fyzickou  adresu 0x10000  (64kB od zacatku  pameti ma  obsazeno
   firmware, a bude to jeste potreba pri detekci videa, apod.). Ale kernel uz
   musime nahrat, protoze az bychom si prepsali prvnich 64kb, nemuseli  bysme
   se uz afaik dostat na disketu

   Poznamka(mm, kt): Protoze  se stale jeste  nahazime v 16tibitovem  realnem
   rezimu, je nutne  vyuzit, eufemisticky receno,  nekolika dalsich  "figlu".
   Rutina, ktera to  zaridi, je  definovana jako  bootsect_helper v  setup.S.
   Odkaz na ni  je v bootsect.S  jako bootsect_kludge (nazev  hovori za  sebe
   :-)). Duvod, proc je rutina definovana v  setup.S a ne v bootsect.S ,  kam
   logicky patri,  je  ten,  ze  v  zavadeci  uz  neni  dost  mista,  pricemz
   programovy kod setup.S  je uz v  pameti (byt  jinde a musi  se kvuli  tomu
   pouzivat mezisegmentovy skok).

  Setup

   Po nahrati komprimovaneho  kernelu se dlouhym  skokem preneseme na  adresu
   $SETUPSEG, kde zacina  programovy kod  setup.S. Komplexnost  setupu je  do
   znacne miry dana  tim, ze musi  zvladnout i dalsi  ruzne pripady, jak  lze
   zavest linuxovy kernel  (bootovani ze  site, loadlin,  LILO, starsi  jadro
   zImage apod.).

   setup.S pak provede zjisteni velikosti pameti (pouzity tri metody,  e820h,
   e801h,  88h),  provede  zakladni  nastaveni  klavesnice,  zavola   runtiny
   definovane ve video.S pro detekci  a vyber textovych videorezimu,  zjisti,
   zda je  zapojena  PS/2 mys,  pripojen  hardisk a  nekolik  dalsi  zakladni
   inicializace APM (Advanced power management, atd.)

   Pote, co jiz nejsou potreba dalsi sluzby BIOSu, je cele komprimovane jadro
   bzImage premisteno  z adresy  $INITSEG (=0x10000  = 64kb)  do dolni  casti
   pameti na $SYSSEG (=0x1000 = 4kb). setup.S pak zaridi vsechny  nalezitosti
   potrebne k  prepnuti  do  chraneneho  80386  rezimu  (zakazani  preruseni,
   nastaveni GDT a podobne).  Kdyz je vsechno hotovo,  setup.S prepne CPU  do
   chraneneho rezimu, vyprazdni instrukcni cache a provede odskok na fyzickou
   adresu 0x1000, coz je programovy kod arch/i386/boot/compressed/head.S.

   head.S uz obsahuje 32bitovy kod. Je potreba si uvedomit, ze fyzicka adresa
   0x1000 je  zaroven  adresou,  kde  bude tabulka  strankovani  -  tedy,  ze
   startovaci programovy kod jadra bude touto tabulkou prepsan.

   Stranka cislo 0  se nechava  volna kvuli nekterym  notebookum, ktere  pres
   tuto oblast pameti  komunikuji s BIOSem.  Navic se toto  pouziva k  ruznym
   trikum uvnitr  jadra -  napriklad ma-li  funkce (napr  __d_path())  vracet
   char*, ale potrebuje nejak dat najevo, ze doslo k chybe, vrati pointer  do
   teto oblasti pameti (makro ERR_PTR), a podle hodnoty pointeru si  volajici
   zjisti, k jake chybe doslo (neni zde errno, toto je jeho obdoba)

   head.S predevsim zavola C rutinu decompress_kernel() ktera je definovana v
   arch/i386/boot/compressed/misc.c, ktera rozbali  programovy kod  vlastniho
   kernelu.

  Dekomprese

   Tady se  nachazime v  dost tezke  situaci,  v tomto  bode totiz  nejsou  k
   dispozici zadne  podpurne  funkce.  Nezbyva  nez  si  nadefinovat  alespon
   nekolik  zakladnich  funkci  jako   memcpy(),  memset().  Upravena   verze
   dekompresniho algoritmu, prevzateho z programu gzip(1), navic potrebuje  i
   malloc() a free()  (s tim  si ostatne aktualni  implementace prilis  hlavu
   nelame, funkce malloc() pouze posunuje  (a zarovnava) ukazatel na  zacatek
   volneho mista, funkce  free() nedela  pro jistotu vubec  nic). Potize  ale
   vyvstavaji i s tak primitivnimi vecmi, jako je vypsani textu na  obrazovku
   - funkce BIOSu uz nejsou k dispozici, takze se pise primo do videoRAMky.

   Zakladni informace o  zobrazovacim systemu uz  jsou znamy z  inicializace,
   kterou provedl  video.S.  Pokud  byl  detekovan  videorezim  c.7,  mame  k
   dispozici jen monochromaticky rezim  80x25, je zvolena adresa  videopameti
   0xB0000 a prislusny port 0x3B4,  v opacnem pripade se predpoklada  adapter
   kompatibilni s barevnou IBM VGA a nastavena je adresa textove  videopameti
   0xB8000 a port 0x3D4. Pocet radku a sloupcu na obrazovce se nastavi  podle
   cisla videomodu. Organizace  videopameti je pro  vsechny textove rezimy  i
   adaptery stejna.

   Je-li k dispozici dostatek pameti,  spusti se dekompresni algoritmus,  tj.
   funkce     makecrc()     a     gunzip,     prekladane     jako     soucast
   arch/i386/boot/compressed/misc.c, ale skutecne definovane v lib/inflate.c

   Pokud   je   dekomprese   uspesne   dokoncena,   rizeni   se   vraci    do
   arch/i386/boot/compressed/head.S, kde programovy kod uz definitivne opusti
   zavadec a provede  odskok na  adresu "opravdoveho kodu"  kernelu, tedy  na
   fyzickou adresu 0x100000.

  Zakladni inicializace jadra

   Startuje  se   na  fyzicke   adrese   0x100000,  tedy   programovem   kodu
   arch/i386/kernel/head.S.

   Segmentove registry nastavime na adresu jadra, inicializujeme  strankovaci
   tabulky (prozatim  jen uvodnich  8MB  pro ucely  startu jadra,  zbytek  se
   vyplni pozdeji, podle velikosti fyzicke pameti). Pak se na procesoru zapne
   strankovani. Pak  je  ihned  potreba vyprazdnit  celou  instrukcni  frontu
   nepodminenym skokem (v opacnem pripade  by instrukce, ktere ma procesor  v
   pipeline uplne zmenily pri zmene adresovani z 16bit na 32bit vyznam).

   Protoze uz  jsme  v 32bitovem  modu,  je potreba  nastavit  znovu  tabulku
   vektoru preruseni. Vsech 256 polozek se prozatim nastavi obsluznou  rutinu
   ignore_int  skutecne  hodnoty   se  nastavi  az   pozdeji.  Procesor   pak
   prekopiruje  2kB  dat  z  prikazove  radky  do  nulte  stranky  pro  dalsi
   zpracovani jadrem.

   (Data pro prikazovou radku uzivatel dava zavadeci jeste v realnem  rezimu,
   ale protoze jsme si v jednom registru ponechali jejich puvodni adresu, tak
   k nim muzeme pristoupit i v 32bitovem rezimu).

   (mm, kt) Po zakladni  detekci typu procesoru a  koprocesoru (jen 386,  486
   nebo lepsi), zbyva jenom spravne  nastavit EFLAGS, a nahrat  deskriptorove
   tabulky (GDT  resp. IDT  nahravaji obsah  definovany pod  gdt_descr  resp.
   idt_descr, LDT je o neco pozdeji nastavena na 0. Pak uz muzeme  pokracovat
   inicializacemi  v  C,  konkretne   funkci  start_kernel()  definovanou   v
   init/main.c. start_kernel() je  architekturove nezavisla, konkretni  kroky
   jednotlivych akci  jsou  samozrejme  pro  kazdou  architekturu  definovany
   zvlast (opet  podrobneji  rozebirame  jen  veci  tykajici  se  x86/x86  MP
   (IA32)).

Startovani jadra(mmkt)

   Funkce start_kernel() provede nasledujici akce:

    1. Uzamkne kernel globalnim zamkem.

       FIXME: Proc nastavuje globalni zamek? Do funkce start_kernel by nemel
       vstoupit jiny nez boot procesor (na architekture x86 se to urcite
       nestane). Interrupty by mely byt take vypnute. Navic nedava smysl, aby
       touto rutinou prochazel dalsi procesor.

    2. Vypise typicky linuxovy "banner".

       Neboli, vypise konstantu linux_banner z init/version.c. Ta udava verzi
       jadra, kdo, kde a kterym kompilerem jadro prelozil. Stejnou informaci
       lze kdykoliv ziskat z /proc/version.

       Poznamka: pokud chceme byt presni: jadro sice zavola pomocnou funkci
       printk() (jaderny ekvivalent printf()), ale ve skutecnosti se hned na
       obrazovku nic nevypisuje. printk() pouze naformatuje dany retezec do
       statickeho bufferu log_buf velikosti LOG_BUF_LEN definovaneho v
       linux/kernel/printk.c. Standardni velikost bufferu je 16kB. Zpravy z
       bufferu log_buf se na obrazovku vypisi az v okamziku, kdy se
       standardnim zpusobem zaregistruje nejaka konzole (console device). To
       je take duvod, proc lze funkci printk() uzit v jadre temer na
       libovolnem miste, vcetne rutiny pro obsluhu preruseni, jak to muzeme
       videt i v pripade ignore_int. Jen je pak treba opet obnovit obsahy
       registru, ktere implementace printk() vyuziva.

    3. Zakladni architekturove zavisla nastaveni.

       Temer vsechny funkce pro zakladni nastaveni architektury x86 jsou
       definovany primo v souboru arch/i386/kernel/setup.c. A vetsina z nich
       ma co do cineni s inicializaci pameti (je dobre si pripomenout, ze
       zatim jeste fungujeme jen v 8MB provizoriu). setup_arch() napred jeste
       nastavi nektere promenne nutne pro pripadne bootovani z ramdisku, root
       device a nekolik dalsich. Dulezita je ale predevsim funkce
       setup_memory_region(), podle ktere se Linux snazi nastavit kompletni
       mapu pameti. Nasledne, ve funkci parse_mem_cmdline(), pak upravi
       pripadna prenastaveni velikosti nebo oblasti pameti podle parametru
       mem= prikazove radky jadra.

       Poznamka: BIOS vraci velmi casto zcela nesmyslne hodnoty, co se
       velikosti fyzicke pameti tyce. Linux proto hodnotu udavanou BIOSem
       ignoruje a misto toho nastavi jako velikost fyzicke RAM jako maximum
       vsech hodnot, ktere se mu podarilo zdetekovat. Podobne je tomu i s
       mapou pameti. Jadro se napred pokusi "opravit" (sanitize_e820_map())
       mapu udanou BIOSem tak, aby se jednotlive pametove oblasti
       neprekryvaly. Pokud to nejde, pouziva maximalne zjednodusene schema -
       jeden blok 0-640kB dolni pameti, dalsi sekce od 1Mb vyse.

       Podle vysledne mapy pameti, nastavi volne ramce stranek dolni pameti
       pro alokator (stranky, ktere jsou vyuzite jen zcasti necha nedotcene)
       a nastavi take pocatecni a koncove ("brk") body pro data a kod jadra.
       Nultou stranku ponecha vzdy volnou - ta na mnoha pocitacich slouzi
       jako specialni stranka BIOSu v nizke pameti. Zpravidla byva vyuzivana
       pro operace se SMP, pro System management u laptopu, pro funkce APM
       (ACPI) a podobne.

       Pokud mame system konfigurovan pro SMP, jadro se pokusi zjistit a
       inicializovat struktury APIC, tj. provede funkci find_smp_config().

       Poznamka: Z historickych duvodu specifikace x86 MP nerika presne, kde
       presne lezi konfiguracni tabulky pro SMP, pouze udava nekolik
       adresovych lokaci, kde by se mohly nachazet. Zrejme tak cini ze snahy,
       co nejvice zachovat kompatibilitu s drivejsimi systemu x86. Kazda z
       uvadenych lokaci totiz muze obsahovat programovy kod pro zarizeni od
       jineho vyrobce (napr. pro inicializacni kod pro nektere SCSI radice)
       nebo dokonce temer libovolny kod, pokud uvedenou adresu nahodou
       pouzije napr. bootloader. Je na jadre, aby takove tabulky dokazalo
       rozpoznat (funkce smp_scan_config()).

       paging_init() pak uz muze dokoncit mapovani pameti (prvnich 8MB uz
       mapovano mame). Nultou stranku z mapovani vyjme, aby bylo mozne v
       jadre odchytit pripadne NULL-dereference. Konfiguraci SMP pak
       prekopiruje do normalni pameti jadra a inicializuje APIC.

       Pokud je system konfigurovan pro bootovani z ramdisku, vyhradi pro nej
       jadro dostatek mista pomocnou funkci reserve_bootmem(). Dale vyhradi
       adresovy prostor vsem prostredkum ROM (pro video, zakladni desku a
       dalsi mozna zarizeni), oblasti videopameti (vram_resource) a vsem IO
       prostredkum (standard_io_resources[0..STANDARD_IO_RESOURCES]). Na
       zaver upravi odkaz na zacatek pameti pro spravu prostredku PCI a
       ostatnich zarizeni mapovanych do pameti (mmaped IO) tak, aby byl na co
       mozna nejnizsich adresach (a tedy nevznikaly problemy s pretecenim do
       bezne RAM).

    4. Vypise a zpracuje parametry predane jadru z prikazove radky pri zavadeni.

       Funkce parse_options() jednoduse zpracuje parametry z prikazove radky,
       kterymi naplni argumenty a evironment (budouciho) threadu init (jako
       promenne environmentu se berou vsechny predane parametry, ktere
       obsahuji znak '=').

       Poznamka: vyjimku tvori parametr 'mem=', kde se zjistuje velikost,
       pripadne konkretni mapa pameti, ktery je uz predem zpracovan a
       interpretovan funkci setup_arch().

       Kazdy predany parametr je navic zaroven subrutinou checksetup()
       otestovan proti symbolum deklarovanym pomoci __setup(). Tj., napriklad
       __setup("foo", foo_bar) asociuje parametr prikazove radky jadra "foo"
       s funkci jadra foo_bar(). Tomu odpovidaji jen parametry pouzivane pro
       interni ucely a threadu init se uz dal nepredavaji. Podrobnejsi popis
       je v souboru linux/Documentation/kernel-parameters.txt

       Normalni (default) seznam argumentu a environmentu init je definovan
       nasledovne:

   static char * argv_init[MAX_INIT_ARGS+2] = { "init", NULL, };
   static char * envp_init[MAX_INIT_ENVS+2] = { "HOME=/", "TERM=linux", NULL, };

       pricemz normalni hodnota MAX_INIT_ARGS i MAX_INIT_ENVS je 8.

       Poznamka: zpracovavani prikazove radky obsahuje jeste jeden
       workaround. Pokud totiz uzivatel pouziva program LILO jako bootloader
       a ponecha normalni (default) prikazovou radku, LILO pred jadru
       predsune jeste slovicko "auto". Pri standardnim zpracovani by pak
       doslo k nedorozumeni, ze se ma pustit program takoveho jmena. Linux to
       resi jednoduse tim, ze vsechny argumenty, ktere predchazeji init=,
       jednoduse ignoruje.

       FIXME: takove chovani neni zrovna korektni, i kdyz jde predevsim o
       chybu zavadece. Kazdopadne by melo byt daleko lepe zaneseno do
       dokumentace.

    5. Provede inicializaci traps a IRQ.

       Tyto esencialni inicializace zakladnich vyjimek, ktere dovede procesor
       poskytnout, provadi funkce trap_init() resp. init_IRQ() definovane v
       arch/i386/kernel/traps.c resp. arch/i386/kernel/i8259.c. Z naseho
       pohledu jsou zajimave predevsim dve volani:

   set_system_gate(SYSCALL_VECTOR,&system_call);

       kde (definovano v include/asm-i386/hw_irq.h)

   #define SYSCALL_VECTOR                0x80

       a system_call je vlastni implementace systemoveho volani (definovana v
       arch/i386/kernel/entry.S, jeste se k ni podrobneji vratime). Do
       tabulky vektoru preruseni je pod cislem 0x80 tedy instalujeme instanci
       uzivatelsky klicoveho prvku - systemove volani. Vlastni implementace
       je samozrejme kvuli rychlosti v assembleru, stejne jako ostatni
       handlery, ktere v teto funkci nastavujeme. Druhe slibene zajimave
       volani je:

   cpu_init();

       Ackoliv jsou uz nektera data v tomto okamziku inicializovana
       (pripomenme napriklad inicializaci tabulky vektoru preruseni IDT
       obsluznou rutinou ignore_int a globalni deskriptorove tabulky GDT uz v
       arch/i386/kernel/head.S), funkce cpu_init() tvori barieru, pri ktere
       je uplne reinicializovan stav CPU. Konkretne cpu_init() dela
       nasledujici akce:

         1. inicializuje stav CPU,
         2. nahraje tabulky GDT a IDT,
         3. shodi NT (Nested Task) bit,
         4. nastavi a nahraje TSS (Task State Segment) a LDT,
         5. vynuluje ladici registry CPU,
         6. nastavi TS (Task Switched) bit, tj. povoli lazy ukladani registru
            pri prepnuti kontextu.

       Druhou cast inicializaci (prevazne pro SMP) provadi funkce init_IRQ().
       Napred nastavi oba 8259A radice ISA IRQ, pak instaluje obsluhy
       preruseni pro:

          o vsechny nepouzite vektory (implicitni obsluha, vetsina vektoru
            pak dostane skutecne obsluzne rutiny)
          o IRQ 0 (je potreba pro inicializaci IO APIC)
          o CPU-to-CPU IPI (Inter-Processor Interrupt) - je potreba pro
            reschedule_helper,
          o invalidaci TLB,
          o lokalni APIC IPI casovac,
          o IPI vektory vyjimek APIC.

       Na zaver nastavi systemove hodiny, aby kazdych HZ (normalne 100) Hz
       generovaly preruseni a pokud ma procesor externi FPU, nastavi
       standardni obsluhu IRQ 13 (na SMP je dvojice IRQ 13 resp. IRQ 16
       pouzivana pro fast resp. slow IPI).

    6. Inicializuje data potrebna pro planovac a spravu procesu.

       Inicializacni funkce sched_init() (definovana v kernel/sched.c)
       nejprve urci aktualni CPU, tj. boot procesor, jako vykonny procesor
       threadu init. Pak vynuluje hashovaci tabulku pidhash.

       FIXME: Tabulka pidhash neni dynamicka, jeji definice a definice
       hashovaci funkce je nasledovna:

   #define PIDHASH_SZ (4096 >> 2)
   extern struct task_struct *pidhash[PIDHASH_SZ];

   #define pid_hashfn(x) ((((x) >> 8) ^ (x)) & (PIDHASH_SZ - 1))

       coz pro pri beznem provozu, kdy jsou spusteny desitky nebo maximalne
       nekolik set procesu soucasne nevadi, problem s rychlosti muze ale
       vznikat, pokud na serveru bezi aplikace, ktera vytvari velky pocet
       threadu (webservery, transakcni systemy,...).

       FIXME: pidhash je pomerne velka staticka tabulka, proc neni umistena
       primo explicitne nulovane BSS, nebo proc alespon neni misto cyklu
       pouzita funkce memset()?

       Funkce dale inicializuje struktury vektoru pro casovace, nastavi
       obsluhy trech specialnich bottom halves (viz nize) timer_bh,
       tqueue_bh, immediate_bh a pro boot idle thread se nastavi lazy
       prepinani MMU.

    7. Inicializuje mechanismus softirq.

       Inicializace vsech mechanizmu softirq je zajistena funkci
       softirq_init() (definice je v souboru kernel/softirq.c).

       Co v Linuxu mechanizmus softirq predstavuje? Predevsim jde o to,
       odlehcit standardni obsluze preruseni. V urcitych pripadech je rozumne
       rozdelit obsluhu preruseni na cast, kterou je nutne vykonat hned
       (prijeti preruseni, update statistik a podobne), a na cast prace,
       kterou lze odlozit na pozdeji, kdy uz jsou preruseni opet povolena
       (napriklad nejake dalsi zpracovani dat nebo probuzeni procesu, ktere
       na data z preruseni cekaji). Puvodne, v Linuxu 1.x, byl pro tento ucel
       vyhrazen mechanizmus tzv. bottom halves. Ten mel nicmene pomerne dost
       neprijemnych omezeni, proto byl v prubehu casu rozsiren a dale doplnen
       na dnesni mechanizmy softirq. V Linuxu 2.4 najdeme nasledujici casti:

          o bottom halves,
          o task queues,
          o tasklets,
          o softirqs.

       Bottom halves predstavuji dnes uz zastaraly zpusob, jak danou
       problematiku v jadre resit. Presto na nekolika mistech v jadre dosud
       pretrvava - patrne se nikomu nechce dal predelavat, co zatim celkem
       staci a alespon bez problemu funguje (i kdyz by to bylo cistsi
       reseni). V systemu muze byt celkem zaregistrovano maximalne 32 bottom
       halves. Nejvetsi omezeni ale plyne ze zpusobu synchronizace. Bottom
       halves jsou serializovany globalnim spinlockem global_bh_spinlock, tj.
       i na SMP systemu muze bezet v jednom okamziku pouze jedna bottom half.
       Zamykani global_bh_lock se presto od zamykani klasickeho spinlocku,
       kde CPU ceka v aktivnim cyklu, vyrazne lisi. Pokud global_bh_lock neni
       k dispozici, je provadeni prislusne bottom half preplanovano, takze
       system neni zbytecne blokovan.

       Task queues jsou konzervativnim rozsirenim bottom halves (nekdy se jim
       take rika "nove bottom halves"). Resi predevsim mensi technicke
       omezeni bottom halves, totiz nemoznost zaregistrovat vice nez jednu
       obsluznou funkci. Task queues dovoluji s pomoci makra queue_task()
       zaregistrovat libovolny pocet obsluznych funkci, ktere jsou pak jedna
       po druhe vyvolavany. V linuxovem jadre jsou preddefinovany ctyri
       zakladni task queues:

          * tq_timer: obsluzne rutiny jsou vyvolavany pri kazdem preruseni
            casovace a pri zavreni terminalu. Obsluha preruseni casovace bezi
            v ramci interrupt kontextu, takze ukoly v teto fronte nemuzou
            pouzivat blokujici operace.
          * tq_scheduler: obsluzne rutiny jsou vyvolavany planovacem a pri
            zavreni terminalu. Nebezi v ramci interrupt kontextu, takze mohou
            pouzivat prakticky libovolne prostredky.
          * tq_immediate: je trida fronty obsluznych rutin, ktere odpovidaji
            puvodni tride bottom halves. Vyvolani obsluznych rutin je mozne
            ridit makrem mark_bh().
          * tq_disk: je trida specifickych obsluznych rutin, ktere maji za
            ukol vyrizovat pozadavky blokovych a RAID zarizeni. Tato task
            queue je exportovana i pro potreby dynamickych modulu jadra.

       Poznamka: Duvod, proc jsou ukoly zarazene v task queues tq_timer a
       tq_scheduler vyvolavany i pri zavreni terminalu (pripadne podobnych
       prilezitostech), je celkem zjevny. Totiz, ze provadeni urcitych akci
       je potreba jen tehdy, pokud ovladac stale jeste muze pracovat s
       konkretni instanci pouzivaneho zarizeni, odkladat to na pozdeji nema
       zadny smysl. Krom toho uz nemuseji byt k dispozici prislusne datove
       struktury. Pri vyvolani obsluznych rutin i v takovemto pripade, lze v
       ovladaci takovou situaci vcas "podchytit".

       Krom preddefinovanych task queues je mozne vyvorit i uplne novou
       frontu s pomoci makra DECLARE_TASK_QUEUE(). Vyvolani obsluznych rutin
       pak probehne pokazde pri volani funkce run_task_queue().

       Tasklets jsou multithreadovou analogii bottom halves. Jejich hlavni
       vyhodou je, ruzne tasklets muzou soucasne bezet na ruznych CPU. Po
       zavolani tasklet_schedule() je garantovano, ze tasklet na tomtez CPU
       alespon jednou probehne, pricemz pokud je uz tasklet naplanovan, ale
       provadeni jeho kodu jeste nezacalo, je garantovano, ze probehne prave
       jednou. Pokud uz tasklet bezi na jinem procesoru (nebo pokud tasklet
       sam zavola funkci schedule()), je preplanovan na pozdeji. Dobrou
       vlastnosti je, ze kazdy tasklet je serializovan pro zapis ve vsech
       svych instancich. Pro instance ruznych taskletu to samozrejme neplati.
       Pokud je takova serializovatelnost potreba, je nutne pouzit spinlocky.
       Vetsina puvodnich bottom halves byla prevedena prave na tasklets.

       Softirqs jsou celkove nejobecnejsi, pouziva se prima hardwarova
       podpora. Zadna serializace se nedela, v pripade nutnosti si ji musi
       klientska funkce zajistit sama. Nepouzivaji se sdilene promenne,
       vsechna data jsou lokalni danemu CPU. Pokud neni nutne, aby byla
       obsluzna rutina vyvolavana opravdu velmi casto, neni potreba pouzivat
       softirq. Pro vetsinu veci naprosto postacuji tasklets.

    8. Zkalibruje a nastavi funkce potrebne pro spravu casu.

       Funkce time_init() (definovana v souboru arch/i386/kernel/time.c)
       napred z CMOS RTC (Real Time Clock) zjisti aktualni cas. V pripade, ze
       CPU disponuje TSC (time stamp counter), mame stesti, staci
       nakalibrovat TSC a muzeme bez problemu pocitat cas velmi presne
       (vetsinou dokonce lepe nez na mikrosekundy). V pripade, ze TSC k
       dispozici neni, musime pouzit mene presne (a navic vyrazne pomalejsi)
       reseni.

       Poznamka: Pokud jste stastnym majitelem viceprocesoroveho systemu s
       procesory i486, z nichz nektere procesory TSC maji a jine ne, mate
       smulu - nebude to fungovat. Ostatne, podle autoru jste patrne jediny
       majitel takoveho systemu, tak si to mate opravit sam.

       CMOS RTC ma sice pomerne dobrou presnost casu za delsi obdobi, kamen
       urazu je rychlost odezvy. RTC zvladne generovat preruseni v rozsahu
       priblizne 8192Hz - 2Hz, coz je ale pro nektera zarizeni prilis dlouhy
       interval. Napriklad jenom audio driver pro PC speaker potrebuje
       preruseni generovane priblizne kazdych 120 mikrosekund. Situace se
       musi obchazet pres casovac 8253, s pomoci ktereho lze dosahnout lepsi
       presnosti.

       Na zaver funkce instaluje standardni obsluhu timer_interrupt()
       (definovanou v souboru arch/i386/kernel/time.c) casovace na IRQ 0 a
       zaregistruje tuto informaci v procfs. Krom jineho, timer_interrupt()
       resp. jeho vykonna funkce do_timer_interrupt() vola rutinu do_timer(),
       ktera inkrementuje hodnotu casoveho pocitadla jiffies a naplanuje
       obsluzne rutiny zaregistrovane v task queue tq_timer.
       do_timer_interrupt() take priblizne kazdych 11 minut updatuje hodnotu
       v RTC.

    9. Predbezne inicializuje konzoli.

       Na inicializace konzole je vlastne prilis brzy, jeste neprobehla
       nastaveni PCI sbernice, vetsiny portu a podobne. Je ale vhodne mit
       alespon nejaky chybovy vystup pro pripad, ze se stane neco spatne.
       console_init() (definovano v drivers/char/tty_io.c) proto prilis
       nespoleha na pomocne funkce jadra a provede jen zakladni inicializaci.

       Poznamka: volani console_init() musi nasledovat az za nastavenimi
       funkci pro spravu casu a softirq, protoze si registruje vlastni
       casovac (pomoci funkce init_timer() definovane v
       include/linux/timer.h) a take vlastni tasklet. Kompletni inicializace
       konzole probehne az pozdeji.

   10. Zapne podporu dynamickeho nahravani modulu.

       Pokud je v konfiguraci jadra nastaveno CONFIG_MODULES, zavola se
       inicializacni funkce init_modules(), ktera predevsim naplni prislusne
       tabulky symbolu jadra. Podrobnosti o modulech jadra lze najit v
       souborech kernel/module.c a kernel/kmod.c.

   11. Zapne podporu profilingu.

       Pokud byla pri startu pozadovana podpora profilovani (napr. parametrem
       "profile=" prikazove radky pri zavadeni), vyhradi se misto pro
       prislusne buffery.

   12. Inicializuje se vetsina subsystemu pro cacheovani.

       Funkce kmem_cache_init() (definovana v souboru mm/slab.c) provede
       inicializaci dat a pametovy odhad pro velikost cache.

   13. Prikazem sti() se povoli harwarova preruseni.

       Tedy se rozbehne i generovani preruseni od casovace a v nasledujicim
       kroku bude mozne provest funkci calibrate_delay().

   14. Nakalibruje, spocte a vypise hodnotu BogoMIPS.

       Hodnota BogoMIPS pritom urcuje, kolik prazdnych cyklu za jiffy je boot
       procesor schopen vykonat.

   15. Provede uplnou inicializaci pameti.

       Funkce mem_init() (definovana v souboru mm/slab.c) predevsim vynuluje
       nultou stranku a veskerou volnou pamet z dolni oblasti pameti prida do
       totalram_pages. Spocte a vytiskne statistiky o celkove/volne pameti,
       velikosti programoveho kodu jadra, pameti, kterou jadro potrebuje pro
       data jadra atd. Protoze SMP jadro bootuje ostatni CPU pomerne pozde,
       je potreba jeste prozatim zachovat nektere oblasti nizke pameti kvuli
       detekcim. Od tohoto okamziku je mozne uz normalne pouzivat funkci
       jadra get_free_pages().

   16. Nastavi softwarove limity pro fork().

       Maximalni (softwarovy) limit pro maximalni pocet threadu je nastaven
       na bezpecnou hodnotu: celkovy objem pameti pro vsechny datove
       struktury potrebne v kernelu pro beh threadu nesmi presahnout 1/2.

   17. Dokonci inicializaci subsystemu cacheovani.

       Pomocne jsou funkce opet definovany v mm/slab.c. Od tohoto okamziku je
       mozne pouzivat i funkci jadra kmalloc().

   18. Inicializuje proc filesystem.

       Inicializuje zakladni datove struktury, zaregistruje souborovy system
       procfs. V profs vytvori soubory obsahujici zakladni informace o
       systemu.

   19. Inicializuje podporu IPC System V.

       Inicializuje standardni prostredky IPC (InterProcess Communication)
       zname ze Systemu V (semafory, zpravy, sdilena pamet) a zaregistruje je
       v procfs. Zajisti (interni) mount souboroveho systemu shmfs.

   20. Pokusi se detekovat nektere hardwarove chyby.

       Zjisti typ a verzi procesoru, pripadne se pokusi zapnout nejaky
       workaround, pokud narazi na vyraznejsi chybu hardwarovou chybu
       procesoru, jako napriklad neosetreny stav pri zpracovani nekorektnich
       instrukci zacinajicich F00F u drivejsich verzi procesoru Pentium.

   21. Ohlasi, ze Linux je POSIX kompatibilni.

       Kompatibilitu se standardem POSIX musi vzdy testovat certifikovana
       firma, v pripade Linuxu je ji UNIFIX.

   22. Inicializuje SMP.

       Inicializace x86 SMP je pomerne slozita zalezitost. V jadre Linuxu se
       o vetsinu akci stara funkce smp_boot_cpus(). Ta (krom jineho) provede
       nasledujici:

          o Inicializuje mtrr registry boot procesoru. Prekontroluje
            inicializace APIC a tabulky BIOSu pro obsluhu preruseni. Ulozi a
            vypise informace dostupne o boot procesoru.

          o Pokud bylo cokoliv spatne, inicializace konci a SMP se vypne.
            System pak pokracuje stejne jako na uniprocesorovem systemu.

          o Prepne system hardwarove obsluhy preruseni z (emulace) PIC do
            symetrickeho modu I/O preruseni.

          o V cyklu pres vsechny procesory (0 <= apicid <= NR_CPUS, krome
            absentujicich a boot procesoru) vola funkci do_boot_cpu(). Ta, s
            pomoci funkce fork_by_hand() pro kazdy nove bootovany (cilovy)
            procesor vytvori idle task a kazdemu procesoru taky "naplanuje"
            budouci prvni ukol:

         idle->processor = cpu;
         x86_cpu_to_apicid[cpu] = apicid;
         x86_apicid_to_cpu[apicid] = cpu;
         idle->has_cpu = 1; /* we schedule the first task manually */
         idle->thread.eip = (unsigned long) start_secondary;

            Poznamka: vsechny idle tasks maji cislo 0, cislo 1 musi patrit
            initu. Vsechny takto vytvorene projekty jsou ihned vyjmuty z
            tabulky pidhash a z fronty bezicich procesu (planovac sice zatim
            nebezi, ale datove struktury uz pripravene mame).

            Do konfiguracnich pametovych lokaci je zapise fyzickou adresu
            rutiny trampoline_base, coz je kopie programoveho kodu
            trampoline_data definovaneho v arch/i386/kernel/trampoline.S.
            Boot procesor pak vysle serii synchronizacnich IPI a STARTUP IPI
            cilovemu CPU, coz znamena pokyn k nastartovani a naslednemu
            provedeni kodu trampoline_base (rutina se musi kopirovat do nizke
            pameti, vyzaduje to MP specifikace Intelu):

         mov     %cs, %ax        # Code and data in the same place
         mov     %ax, %ds

         mov     $1, %bx         # Flag an SMP trampoline
         cli                     # We should be safe anyway

         movl    $0xA5A5A5A5, trampoline_data - r_base
                                 # write marker for master knows we're running

         lidt    idt_48 - r_base # load idt with 0, 0
         lgdt    gdt_48 - r_base # load gdt with whatever is appropriate

         xor     %ax, %ax
         inc     %ax             # protected mode (PE) bit
         lmsw    %ax             # into protected mode
         jmp     flush_instr
 flush_instr:
         ljmpl   $__KERNEL_CS, $0x00100000
                         # jump to startup_32 in arch/i386/kernel/head.S

 idt_48:
         .word   0                       # idt limit = 0
         .word   0, 0                    # idt base = 0L

 gdt_48:
         .word   0x0800                  # gdt limit = 2048, 256 GDT entries
         .long   gdt_table-__PAGE_OFFSET # gdt base = gdt (first SMP CPU)

            Po nastartovani ciloveho procesoru se na danem CPU opet ocitame v
            16tibitovem realnem modu, tomu samozrejme musi odpovidat i
            programovy kod trampoline_base(). Cilovy procesor po prekryti
            datoveho a kodoveho segmentu zapise do vlastniho programoveho
            kodu identifikacni konstantu 0xA5A5A5A5, nahraje si provizorni
            lokalni i globalni deskriptorovou tabulku a po prepnuti do
            chraneneho rezimu provede odskok do jiz znameho programoveho kodu
            arch/i386/kernel/head.S. Na rozdil od boot procesoru, kde byl
            pred skokem ze zavadece arch/i386/boot/compressed/head.S do
            arch/i386/kernel/head.S registr %bx explicitne vynulovan, cilovy
            procesor jej nastavuje na hodnotu 1. Diky tomu lze pak cilovy a
            boot procesor snadno rozlisit a tedy i zajistit, aby cilovy
            procesor neprovadel vsechen inicializacni kod v head.S, ale jen
            potrebne casti (neprovadi tedy napr. znovu inicializace BSS,
            ktera v tomto okamziku znicila vetsinu pracne vyrobenych
            programovych struktur). Podobne, misto start_kernel() zavola
            cilovy procesor rutinu inicialize_secondary() definovanou v
            kernel/smpboot.c,

         asm volatile(
                 "movl %0,%%esp\n\t"
                 "jmp *%1"
                 :
                 :"r" (current->thread.esp),"r" (current->thread.eip));

            ktera jednoduse skoci na "dalsi naplanovany" ukol - tedy na
            rutinu start_secondary():

         cpu_init();
         smp_callin();
         while (!atomic_read(&smp_commenced))
                 rep_nop();
         /*
          * low-memory mappings have been cleared, flush them from
          * the local TLBs too.
          */
         local_flush_tlb();

         return cpu_idle();

            Cilovy procesor tedy znovu uplne reinicializujeme pomoci
            cpu_init() (viz vyse) a zavolame smp_callin(), ktera provede
            finalni inicializace procesoru a ceka na spinlocku dokud boot
            procesor nevyrobi vsechny idle threads i pro ostatni CPU
            (planovac totiz predpoklada, ze je na kazdem CPU vzdy co spustit,
            prinejhorsim prave alespon idle thread).

            Mezitim boot procesor ceka (maximalne vsak 5 sekund) nez cilovy
            procesor nabootuje. Pokud programovy kod na adrese
            trampoline_data - r_base obsahuje neco jineho nez konstantu
            0xA5A5A5A5, predpoklada neuspech, vypise prislusnou chybovou
            hlasku a procesor v tabulkach vyradi. V opacnem pripade pokracuje
            startovanim dalsiho procesoru (starty procesoru jsou tedy
            serializovane).

          o Vypise souhrnnou hodnotu BogoMIPS vsech procesoru. Ta je sice k
            nicemu, protoze jedine, co by nas mohlo zajimat jsou individualni
            hodnoty BogoMIPS pro kazdy procesor, ale co by to bylo za
            operacni system, kdybyste svym pratelum nemohli hned po startu
            ukazat, jak uzasne rychly pocitac maji tu cest videt.

          o Nastavi a zkalibruje vsechny lokalni casovace APIC. Pak provede
            synchronizaci TSC vsech nove nastartovanych procesoru s boot
            procesorem.

          o Uvolni pamet pro inicializacni rutiny potrebne k nastartovani SMP
            a vyprazdni TLB vsech procesoru.

       V tomto okamziku jediny procesor, ktery opet provadi nejaky dalsi
       programovy kod, je boot procesor. Konkretne je prave za funkci
       smp_boot_cpus() v smp_init(). Ostatni, plne inicializovane CPU cekaji
       na spinlocku ve funkci smp_callin(). Volanim smp_commence()
       definitivne odstartujeme viceprocesorovy rezim behu systemu.
       Procesory, ktere cekaly v smp_callin(), budou pokracovat ve svych
       programech - po opetovnem vyprazdneni svych lokalnich TLB cache skoci
       do rutiny cpu_idle(), kde pak uz normalne provadeji funkci idle()
       dokud jim schedule() neprideli neco lepsiho.

   23. Boot procesor dokonci inicializaci a spusti init thread.

       Funkce rest_init() vytvori novy kernelovy thread init, odemkne
       globalni zamek a nastavi flag, ze ma byt aktualni thread uvnitr volani
       schedule() preplanovan.

       Poznamka: na SMP nutne potrebujeme napred dokoncit provadeni funkci
       vne threadu init, protoze v opacnem pripade by mohla nastat i situace,
       ze by v dusledku volani funkce free_initmem() z init threadu mohlo
       dojit prepsani dat, ktere jeste potrebuje start_kernel() k uspesnemu
       dokonceni.

       Funkce cpu_idle() pak zustane jako proces cislo 0 (tzv. idle thread).
       Pokud je kernel konfigurovan pro APM nebo ACPI, provadi kod podle
       danych specifikaci podpory power-saving. V opacnem pripade provadi
       instrukci "hlt" a pousti preplanovani procesu schedule().

Init thread

   System je  uz v  podstate  inicializovany, vsechna  CPU uz  nabootovala  a
   provadeji svoje idle  threads, pamet  i sprava  procesu funguje  normalne.
   Krome  konzole,  casovacu  a  nekolika  radicu  nezbytnych  pro  pocatecni
   nastartovani systemu,  jsme  ale dosud  opomijeli  inicializaci  prakticky
   vsech zarizeni. Prave ted uz dozral cas to napravit.

   Init thread, proces  cislo 1, (pote  co je naplanovan  pro nektere z  CPU)
   zacne  provadet  funkci  init()  ze  souboru  init/main.c.  Zamkne   jadro
   globalnim zamkem a provede do_basic_setup(), tedy predevsim

     * inicializaci sbernic,
     * inicializaci sitoveho rozhrani,
     * nastartuje "context thread" keventd,
     * zavola funkci do_initcalls():

         call = &__initcall_start;
         do {
                 (*call)();
                 call++;
         } while (call < &__initcall_end);

         /* Make sure there is no pending stuff from the initcall sequence */
         flush_scheduled_tasks();

       ktera postupne projde seznam vsech inicializacnich funkci
       zaregistrovanych pomoci maker __initcall() nebo module_init() a
       provede je. Prave do teto skupiny spada (mozna prekvapive) nejen
       vetsina ovladacu, ale napriklad i souborove systemy, kswapd, video
       framebuffery nebo rizeni spotreby elektrickeho proudu.

       Prozatim ale neni uplne uspokojive vyreseno poradi volani jednotlivych
       inicializacnich funkci. Pri inicializaci nezavislych subsystemu to
       nevadi. Pokud mame dva na sobe zavisle subsystemy a alespon jeden z
       nich je kompilovan jako modul, pak problem taky nevznika (v kodu je
       jednoznacne uvedene misto, kde se o nahrati zavisleho modulu pozada).
       V jakem poradi se ale budou volat inicializacni funkce subsystemu,
       ktere jsou oba staticky zakompilovany do jadra? Poradi volani
       inicializaci pak zavisi na poradi, ve kterem jsou uvedeny v ELF
       hlavicce jadra, v sekci .initcall.init. To znamena, ze poradi volani
       zavisi napr. i na strukture Makefiles. Prozatim je tedy nutne problemy
       se zavislostmi resit uz v dobe kompilace.

     * Na zaver provede inicializaci IRDA a subsystemu pro PCMCIA (PC Cards).

   Kdyz je  zakladni nastaveni  systemu dokonceno,  pokracujeme uz  rovnou  k
   cili. Funkce prepare_namespace(),  primontuje filesystem  a devfs  (pomoci
   mount_root() resp.  mount_devfs_fs()), pripadne  nastartuje kernel  thread
   linuxrc, ktery umozni  zavest root filesystem  na ramdisk (mechanismus  je
   podrobne rozebiran v souboru linux/Documentation/initrd.txt).

   Jadro pak funkci free_initmem() uvolni veskerou pamet, ktera byla oznacena
   jako kod/data  jen pro  inicializace. Na  typickem systemu  je to  nekolik
   desitek az stovek kilobytu.

   Poznamka: k oznaceni takove pameti  se pouziva podpory kompilatoru.  Makra
   __init, __initdata, __init_call  a init_setup  (pro moduly  take __exit  a
   exit_data) expanduji na prikazy pro assembler .section ".text.init"  resp.
   .section  ".data.init",  ktere  zaruci  umisteni  oznacenych  dat/kodu  do
   prislusnych sekce ELF souboru vmlinux. Kompletni mapu generuje linker  pri
   kompilaci do  souboru  arch/i386/vmlinux.lds.  Funkci  free_initmem()  pak
   staci uvolni  vsechny  stranky  mezi adresami  __init_begin  a  __init_end
   urcujici hranice obrazu inicializacni sekce ve fyzicke pameti.

   Init  thread  pak  odemkne   globalni  zamek,  otevre  inicialni   konzoli
   /dev/console a prislusny filedeskriptor  dvakrat zduplikuje (dup(2))  tak,
   aby slouzil jako stdin, stdout a  stderr pro program init a jeho  potomky.
   Na zaver spusti program init:

         /*
          * We try each of these until one succeeds.
          *
          * The Bourne shell can be used instead of init if we are
          * trying to recover a really broken machine.
          */

         if (execute_command)   /* user supplied init program */
                 execve(execute_command,argv_init,envp_init);
         execve("/sbin/init",argv_init,envp_init);
         execve("/etc/init",argv_init,envp_init);
         execve("/bin/init",argv_init,envp_init);
         execve("/bin/sh",argv_init,envp_init);
         panic("No init found.  Try passing init= option to kernel.");

   A je tam, muzeme si tykat ;).



   ----
   http://www.jikos.cz/jikos/linboot.html
