#ifndef ARCANE__EXCEPTION_H
#define ARCANE__EXCEPTION_H

/*
 * arcane - A rogue-like game engine
 * Copyright (C) 2005  Petr Baudis <pasky@ucw.cz>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdexcept>

/* This is exceptions factory - means for easy exceptions declaration. */
/* All exceptions should be in namespaces of their respective objects
 * and should be named as "Xfrom_what". */

#define EXCEPT_BASE1(name_, param_, error_) \
	class name_ : public std::runtime_error { \
		public: name_ param_ : std::runtime_error(error_)
#define EXCEPT_BASE2 };

#define EXCEPTION(name_, param_, error_) \
	EXCEPT_BASE1(name_, param_, error_) { } EXCEPT_BASE2

#endif
