/*
 * arcane - A rogue-like game engine
 * Copyright (C) 2005  Petr Baudis <pasky@ucw.cz>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "creature.h"
#include "game.h"
#include "monster.h"


void
Game::tick()
{
	curlevel_->pretick(*this);

	// monsters can die along the way, unfortunately
	for (std::list<Creature *>::const_iterator obj = curlevel_->life.begin();
	     obj != curlevel_->life.end(); obj++)
		(*obj)->get();
	for (std::list<Creature *>::const_iterator obj = curlevel_->life.begin();
	     obj != curlevel_->life.end(); obj++) {
		if ((*obj)->player()) {
			// player must come last
			continue;
		}
		(*obj)->tick(*this);
	}
	for (std::list<Creature *>::const_iterator obj = curlevel_->life.begin();
	     obj != curlevel_->life.end(); ) {
		std::list<Creature *>::const_iterator obj2 = obj; obj2++;
		(*obj)->put();
		obj = obj2;
	}

	player_.tick(*this);

	curlevel_->posttick(*this);
}
