#ifndef ARCANE__ITEM_H
#define ARCANE__ITEM_H

/*
 * arcane - A rogue-like game engine
 * Copyright (C) 2005  Petr Baudis <pasky@ucw.cz>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "atoms.h"
#include "iinfo.h"
#include "mapobj.h"
#include "term.h"
#include "util.h"


class Item: public Drawable {
public:
	Item(ItemInfo &iinfo);

	virtual void draw(Term &term, unsigned x, unsigned y) const;

	PROP_SIMPLE_RO(enum ItemType, type);
	PROP_SIMPLE_RO(enum Color, color);
	PROP_SIMPLE_RO(int, weight);

private:
	ItemInfo &iinfo_;
};


class Level;

// This is item's container on the map.
class ItemOnMap: public MapObject {
public:
	ItemOnMap(Item *item, Level *level, unsigned x, unsigned y);
	static ItemOnMap *corporealize_random(ItemInfo &iinfo, Level *level);
	static ItemOnMap *corporealize_nearby(ItemInfo &iinfo, MapObject &whom, Level *level);

	PROP_SIMPLE_RO(unsigned, weight);
	PROP_SIMPLE_RO(Item *, item);
};


#endif
