#ifndef ARCANE__MAPOBJ_H
#define ARCANE__MAPOBJ_H

/*
 * arcane - A rogue-like game engine
 * Copyright (C) 2005  Petr Baudis <pasky@ucw.cz>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "atoms.h"
#include "exception.h"
#include "term.h"
#include "util.h"


class Level;

/* This is a generic virtual class from which all objects which are present on
 * the level map are derived. */
class MapObject : public Drawable {
public:
	MapObject(Level *level, unsigned x, unsigned y, char symbol, enum Color color);
	virtual ~MapObject();

	EXCEPTION(X_rockdir, (enum Direction dir), "Rock in direction: " + tostr(long(dir)));
	EXCEPTION(X_badobj, (), "Bad map object.");

	virtual void draw(Term &term, unsigned base_x, unsigned base_y) const;

	virtual void move(enum Direction dir);
	// TODO: teleport()

	PROP_SIMPLE_RO(Level *, level);
	PROP_SIMPLE_RO(unsigned, x);
	PROP_SIMPLE_RO(unsigned, y);

	PROP_SIMPLE_RO(char, symbol);
	PROP_SIMPLE_VRO(enum Color, color);
	PROP_SIMPLE(bool, visible);

	PROP_SIMPLE_RO(unsigned, illum_range); // 0 == not an illuminator
public: void illum_range(unsigned illum_range);

protected:
	// We need to be able to change those later in the item initializer
	void symbol(char symbol) { symbol_ = symbol; }
	void color(enum Color color) { color_ = color; }
};


#endif
