#ifndef ARCANE__PLAYER_H
#define ARCANE__PLAYER_H

/*
 * arcane - A rogue-like game engine
 * Copyright (C) 2005  Petr Baudis <pasky@ucw.cz>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "atoms.h"
#include "creature.h"
#include "game.h"
#include "level.h"


class Player: public Creature {
public:
	Player(CreatureInfo &cinfo, Level *level, unsigned x, unsigned y);

	virtual void draw(Term &term, unsigned base_x, unsigned base_y) const;
	virtual void tick(Game &game);

	virtual void die(std::string &msg);
	virtual void move(enum Direction dir);

	virtual bool player() const { return true; }
};

#endif
