/*
 * arcane - A rogue-like game engine
 * Copyright (C) 2005  Petr Baudis <pasky@ucw.cz>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <string>
using namespace std;

#include "term.h"
#include "uti.h"

#include <uti/term.h>
#include <uti/termenum.h>


TermUTI::TermUTI()
{
	init_terminal();
	Tcls();
	setcolor(fg, bg);
}

TermUTI::~TermUTI()
{
	setcolor(COLOR_GRAY, COLOR_BLACK);
	Tgoto(rows - 1, 0);
	Trefresh();
	cleanup_terminal();
}

TermUTI &
TermUTI::color(enum Color fg_, enum Color bg_)
{
	if (fg_ != COLOR_ANY)
		fg = fg_;
	if (bg_ != COLOR_ANY)
		bg = bg_;
	if (fg == bg)
		fg = enum Color(int(fg) ^ 8);
	setcolor(fg, bg);
	return *this;
}

TermUTI &
TermUTI::cursor(int x, int y)
{
	Tgoto(y, x);
	return *this;
}

TermUTI &
TermUTI::put(const std::string str)
{
	Tputs(str.c_str());
	//Tredraw();
	return *this;
}

Key &
TermUTI::get(Key &ch)
{
	Tgoto(il_y, il_x);
	return (ch = (Key) Tgetkey());
}


TermUTI &
TermUTI::clear(int x1, int y1, int x2, int y2)
{
	Tclear(y1, x1, y2 - y1 + 1, x2 - x1 + 1);
	return *this;
}


int
TermUTI::width()
{
	return columns;
}

int
TermUTI::height()
{
	return rows;
}



void
TermUTI::backspace()
{
	Tputt('\010');
}

void
TermUTI::setcolor(enum Color fg, enum Color bg)
{
	// Some extra magic used to be here.
	Tsetattr(bg, fg, 0);
}
