/*
 *	Universal Termcap Terminal Interface -- List of Capabilities
 *
 *	(c) 1997--1999 Martin Mares, <mj@ericsson.cz>
 */

#ifdef CAPS_LIST_HERE
#define CAPS_LIST_START(x) static char x[] =
#define C(x) x
#define CAPS_LIST_END ;
#else
#define CAPS_LIST_START(x) extern char x[] ;
#define C(x)
#define CAPS_LIST_END
#endif

CAPS_LIST_START(tc_numerics)
     C("co")
#define TN_COLUMNS 0			/* . */
     C("li")
#define TN_LINES 1			/* . */
     C("sg")
#define TN_MAGIC_COOKIE_WIDTH 2		/* . */
     C("ug")
#define TN_UNDERLINE_COOKIE_WIDTH 3	/* . */
     C("it")
#define TN_DEFAULT_TABS 4		/* . */
     C("pb")
#define TN_PADDING_MIN_BAUD 5		/* . */
     C("dC")
#define TN_PAD_CR 6			/* . */
     C("dN")
#define TN_PAD_LF 7			/* . */
     C("dB")
#define TN_PAD_BS 8			/* . */
     C("dT")
#define TN_PAD_TAB 9			/* . */
     C("NC")
#define TN_COLORS_DISABLE_ATTRS 10	/* . */
     C("Co")
#define TN_NUM_OF_COLORS 11		/* . */
     CAPS_LIST_END
#define TN_SIZEOF 12

CAPS_LIST_START(tc_bools)
     C("os")
#define TB_OVERSTRIKE 0			/* . */
     C("eo")
#define TB_SPACE_ERASES 1		/* . */
     C("bw")
#define TB_LEFT_WORKS_IN_COL_ZERO 2	/* . */
     C("am")
#define TB_AUTO_MARGINS 3		/* . */
     C("xn")
#define TB_STRANGE_AUTO_MARGINS 4	/* . */
     C("ns")
#define TB_DOESNT_SCROLL_AT_BOTTOM 5
     C("mi")
#define TB_CAN_MOVE_IN_INSERT 6		/* . */
     C("ms")
#define TB_CAN_MOVE_WITH_ATTR 7		/* . */
     C("xs")
#define TB_ONLY_CLR_RESETS_ATTR 8	/* . */
     C("km")
#define TB_HAS_META 9			/* . */
     C("gn")
#define TB_GENERIC 10			/* . */
     C("hc")
#define TB_HARDCOPY 11			/* . */
     C("hl")
#define TB_HLS_COLORS 12		/* . */
     C("in")
#define TB_INSERT_NULL_GLITCH 13
     C("xo")
#define TB_XON_XOFF 14			/* . */
     C("ut")
#define TB_ERASES_WITH_BACK_COLOR 15	/* . */
     C("xt")
#define TB_DESTRUCTIVE_TABS 16		/* . */
     CAPS_LIST_END
#define TB_SIZEOF 17

CAPS_LIST_START(tc_strings)
     C("rp")
#define TS_REPEAT 0			/* . */
     C("cm")
#define TS_MOVE 1			/* . */
     C("ho")
#define TS_HOME 2			/* . */
     C("ll")
#define TS_LOWER_LEFT 3			/* . */
     C("cr")
#define TS_CR 4				/* . */
     C("le")
#define TS_LEFT 5			/* . */
     C("nd")
#define TS_RIGHT 6			/* . */
     C("up")
#define TS_UP 7				/* . */
     C("do")
#define TS_DOWN 8			/* . */
     C("nw")
#define TS_NL 9				/* . */
     C("DO")
#define TS_MULTI_DOWN 10		/* . */
     C("UP")
#define TS_MULTI_UP 11			/* . */
     C("LE")
#define TS_MULTI_LEFT 12		/* . */
     C("RI")
#define TS_MULTI_RIGHT 13		/* . */
     C("ch")
#define TS_SET_COLUMN 14		/* . */
     C("cv")
#define TS_SET_ROW 15			/* . */
     C("ta")
#define TS_TAB 16			/* . */
     C("bt")
#define TS_BACK_TAB 17			/* . */
     C("sf")
#define TS_SCROLL_UP 18
     C("sr")
#define TS_SCROLL_DOWN 19
     C("SF")
#define TS_SCROLL_UP_X 20
     C("SR")
#define TS_SCROLL_DOWN_X 21
     C("cs")
#define TS_SET_SCROLL_REGION 22
     C("cS")
#define TS_SET_SCROLL_REGION2 23
     C("wi")
#define TS_SET_WINDOW 24
     C("cl")
#define TS_CLEAR_SCREEN 25		/* . */
     C("cd")
#define TS_CLEAR_TO_EOS 26		/* . */
     C("ce")
#define TS_CLEAR_TO_EOL 27		/* . */
     C("ec")
#define TS_CLEAR_N_CHARS 28		/* . */
     C("al")
#define TS_INSERT_LINE 29
     C("dl")
#define TS_DELETE_LINE 30
     C("AL")
#define TS_INSERT_LINES 31
     C("DL")
#define TS_DELETE_LINES 32
     C("im")
#define TS_INSERT_ON 33
     C("ei")
#define TS_INSERT_OFF 34
     C("ic")
#define TS_INSERT_CHAR 35
     C("ip")
#define TS_POSTINSERT_CHAR 36
     C("IC")
#define TS_INSERT_CHARS 37
     C("dc")
#define TS_DELETE_CHAR 38
     C("DC")
#define TS_DELETE_CHARS 39
     C("dm")
#define TS_DELETE_ON 40
     C("ed")
#define TS_DELETE_OFF 41
     C("so")
#define TS_STANDOUT_ON 42		/* . */
     C("se")
#define TS_STANDOUT_OFF 43		/* . */
     C("mb")
#define TS_BLINK 44			/*  */
     C("md")
#define TS_BRIGHT 45			/* . */
     C("mh")
#define TS_HALFBRIGHT 46		/* . */
     C("mr")
#define TS_INVERSE 47			/* . */
     C("me")
#define TS_NORMAL 48			/* . */
     C("as")
#define TS_ALTERNATE 49			/* . */
     C("ae")
#define TS_NO_ALTERNATE 50		/* . */
     C("sa")
#define TS_SET_ALL_ATTRS 51		/* . */
     C("us")
#define TS_UNDERLINE_ON 52		/* . */
     C("ue")
#define TS_UNDERLINE_OFF 53		/* . */
     C("vs")
#define TS_CURSOR_ENHANCE 54		/* . */
     C("vi")
#define TS_CURSOR_OFF 55		/* . */
     C("ve")
#define TS_CURSOR_NORMAL 56		/* . */
     C("bl")
#define TS_BELL 57			/* . */
     C("vb")
#define TS_VISUAL_BELL 58		/* . */
     C("ks")
#define TS_ENABLE_FUNC_KEYS 59		/* . */
     C("ke")
#define TS_DISABLE_FUNC_KEYS 60		/* . */
     C("mm")
#define TS_ENABLE_META 61		/* . */
     C("mo")
#define TS_DISABLE_META 62		/* . */
     C("ti")
#define TS_INIT 63			/* . */
     C("te")
#define TS_CLEANUP 64			/* . */
     C("pc")
#define TS_PAD 65			/* . */
     C("SA")
#define TS_ENTER_AM_MODE 66
     C("RA")
#define TS_EXIT_AM_MODE 67
     C("ZH")
#define TS_ITALIC_ON 68			/* . */
     C("ZR")
#define TS_ITALIC_OFF 69		/* . */
     C("ZM")
#define TS_SHADOW_ON 70			/* . */
     C("ZU")
#define TS_SHADOW_OFF 71		/*  */
     C("AB")
#define TS_SET_ANSI_BACKGROUND 72	/* . */
     C("AF")
#define TS_SET_ANSI_FOREGROUND 73	/* . */
     C("Sb")
#define TS_SET_BACKGROUND 74
     C("Sf")
#define TS_SET_FOREGROUND 75
     C("XF")
#define TS_XOFF 76			/* . */
     C("XN")
#define TS_XON 77			/* . */
     C("Zx")
#define TS_ZERO_MOTION 78
     C("ac")
#define TS_GFX_CHARS 79			/* . */
     C("eA")
#define TS_ENABLE_ALT_CHAR_SET 80	/* . */
     C("S2")
#define TS_ENABLE_PC_MODE 81		/* . */
     C("S3")
#define TS_DISABLE_PC_MODE 82		/* . */
     CAPS_LIST_END
#define TS_SIZEOF 83

CAPS_LIST_START(tc_keys)
     C("K1")
#define TK_UPPER_LEFT 0
     C("K3")
#define TK_UPPER_RIGHT 1
     C("K2")
#define TK_CENTER 2
     C("kb")
#define TK_BACKSPACE 3
     C("kB")
#define TK_BACKTAB 4
     C("K4")
#define TK_LOWER_LEFT 5
     C("K5")
#define TK_LOWER_RIGHT 6
     C("kD")
#define TK_DELETE 7
     C("kd")
#define TK_DOWN 8
     C("kM")
#define TK_INSERT_TOGGLE_DUMMY 9
     C("@7")
#define TK_END 10
     C("@8")
#define TK_ENTER 11
     C("@9")
#define TK_EXIT 12
     C("k0")
#define TK_F0 13
     C("k1")
#define TK_F1 14
     C("k2")
#define TK_F2 15
     C("k3")
#define TK_F3 16
     C("k4")
#define TK_F4 17
     C("k5")
#define TK_F5 18
     C("k6")
#define TK_F6 19
     C("k7")
#define TK_F7 20
     C("k8")
#define TK_F8 21
     C("k9")
#define TK_F9 22
     C("k;")
#define TK_F10 23
     C("%1")
#define TK_HELP 24
     C("kh")
#define TK_HOME 25
     C("kI")
#define TK_INSERT 26
     C("kl")
#define TK_LEFT 27
     C("kN")
#define TK_NEXT_PAGE 28
     C("kP")
#define TK_PREV_PAGE 29
     C("kr")
#define TK_RIGHT 30
     C("ku")
#define TK_UP 31
     CAPS_LIST_END
#define TK_SIZEOF 32

#undef CAPS_LIST_START
#undef CAPS_LIST_END
#undef C

extern int t_bools[TB_SIZEOF], t_ints[TN_SIZEOF];
extern char *t_strs[TS_SIZEOF], *t_keys[TK_SIZEOF];

#define BOOL(x) t_bools[TB_##x]
#define INT(x) t_ints[TN_##x]
#define HAVE(x) (INT(x) != -1)
#define STR(x) t_strs[TS_##x]
#define EMPTY(x) (!*STR(x))
