/*
 *	Universal Terminal Interface -- Graphic Characters
 *
 *	(c) 1997 Martin Mares, <mj@ericsson.cz>
 */

#include "termint.h"

/* Graphics chars */

static char gfx_ascii[] = "++++++++-|+~_+:\\#o<>v^###++++++++-|+++++++++++++++++++";
static char gfx_vt100[] = "lmkjtuvwqxnos`afg~,+.-hI0lmkjtuvwqxnnntuvwtuvwlmkjlmkj";
/*                         012345678901234567890123456789012345678901234567890123 */
/*			   000000000011111111112222222222333333333344444444445555 */
static char gfx_peecee[] = {
  0xda, 0xc0, 0xbf, 0xd9, 0xc3, 0xb4, 0xc1, 0xc2, 0xc4, 0xb3,
  0xc5,  '~',  '_', 0x04, 0xb1, 0xf8, 0xf1, 0x07, 0x1b, 0x1a,
  0x19, 0x18, 0xb0, 0x0f, 0xdb, 0xc9, 0xc8, 0xbb, 0xbc, 0xcc,
  0xb9, 0xca, 0xcb, 0xcd, 0xba, 0xce, 0xd7, 0xd8, 0xc7, 0xb6,
  0xd0, 0xd2, 0xc6, 0xb5, 0xcf, 0xd1, 0xd6, 0xd3, 0xb7, 0xbd,
  0xd5, 0xd4, 0xb8, 0xbe
};

char *gfx_chars = gfx_ascii;

void
gfx_setup(void)
{
  char *alternate_on, *alternate_off;

  if (STR(ENABLE_PC_MODE) && !CTRL(NO_PC_GRAPHICS))
    {
      alternate_on = STR(ENABLE_PC_MODE);
      alternate_off = STR(DISABLE_PC_MODE);
      gfx_chars = gfx_peecee;
      DBG(("Using PC graphics\n"));
      supported_attrs |= ATTR_ALTERNATE;
    }
  else if (STR(ALTERNATE) && !(supported_attrs & ATTR_ALTERNATE))
    {
      DBG(("Graphics disabled because of color collisions\n"));
      return;				/* Alternate set disabled => no gfx chars */
    }
  else if (STR(ALTERNATE) && STR(GFX_CHARS) && !CTRL(NO_VT_GRAPHICS))
    {
      char *c;
      ulg i;

      DBG(("Using user-defined graphics\n"));
      c = STR(GFX_CHARS);
      while (*c && c[1])
	{
	  int k = c[0];
	  for(i=0; i<sizeof(gfx_vt100); i++)
	    if (gfx_vt100[i] == k)
	      gfx_chars[i] = c[1];
	  c += 2;
	}
      alternate_on = STR(ALTERNATE);
      alternate_off = STR(NO_ALTERNATE);
    }
  else {
    DBG(("Using ASCII graphics\n"));
    alternate_on = alternate_off = "";
  }

  set_attr[7] = alternate_on;
  reset_attr[7] = alternate_off;

#if 0
  send(alternate_on);
  printf("\r\n");
  printf("%c%c%c%c%c\r\n", gfx_chars[GFX_UL], gfx_chars[GFX_HLINE], gfx_chars[GFX_TTEE],
	 gfx_chars[GFX_HLINE], gfx_chars[GFX_UR]);
  printf("%c%c%c%c%c\r\n", gfx_chars[GFX_VLINE], ' ', gfx_chars[GFX_VLINE],
	 ' ', gfx_chars[GFX_VLINE]);
  printf("%c%c%c%c%c\r\n", gfx_chars[GFX_LTEE], gfx_chars[GFX_HLINE], gfx_chars[GFX_PLUS],
	 gfx_chars[GFX_HLINE], gfx_chars[GFX_RTEE]);
  printf("%c%c%c%c%c\r\n", gfx_chars[GFX_VLINE], ' ', gfx_chars[GFX_VLINE],
	 ' ', gfx_chars[GFX_VLINE]);
  printf("%c%c%c%c%c\r\n", gfx_chars[GFX_LL], gfx_chars[GFX_HLINE], gfx_chars[GFX_BTEE],
	 gfx_chars[GFX_HLINE], gfx_chars[GFX_LR]);
  printf("\r\n");
  printf("%c%c%c%c%c\r\n", gfx_chars[GFX_DUL], gfx_chars[GFX_DHLINE], gfx_chars[GFX_DTTEE],
	 gfx_chars[GFX_DHLINE], gfx_chars[GFX_DUR]);
  printf("%c%c%c%c%c\r\n", gfx_chars[GFX_DVLINE], ' ', gfx_chars[GFX_DVLINE],
	 ' ', gfx_chars[GFX_DVLINE]);
  printf("%c%c%c%c%c\r\n", gfx_chars[GFX_DLTEE], gfx_chars[GFX_DHLINE], gfx_chars[GFX_DPLUS],
	 gfx_chars[GFX_DHLINE], gfx_chars[GFX_DRTEE]);
  printf("%c%c%c%c%c\r\n", gfx_chars[GFX_DVLINE], ' ', gfx_chars[GFX_DVLINE],
	 ' ', gfx_chars[GFX_DVLINE]);
  printf("%c%c%c%c%c\r\n", gfx_chars[GFX_DLL], gfx_chars[GFX_DHLINE], gfx_chars[GFX_DBTEE],
	 gfx_chars[GFX_DHLINE], gfx_chars[GFX_DLR]);
  printf("\r\n");
  printf("%c%c%c%c%c\r\n", gfx_chars[GFX_SDUL], gfx_chars[GFX_DHLINE], gfx_chars[GFX_SDTTEE],
	 gfx_chars[GFX_DHLINE], gfx_chars[GFX_SDUR]);
  printf("%c%c%c%c%c\r\n", gfx_chars[GFX_VLINE], ' ', gfx_chars[GFX_VLINE],
	 ' ', gfx_chars[GFX_VLINE]);
  printf("%c%c%c%c%c\r\n", gfx_chars[GFX_SDLTEE], gfx_chars[GFX_DHLINE], gfx_chars[GFX_SDPLUS],
	 gfx_chars[GFX_DHLINE], gfx_chars[GFX_SDRTEE]);
  printf("%c%c%c%c%c\r\n", gfx_chars[GFX_VLINE], ' ', gfx_chars[GFX_VLINE],
	 ' ', gfx_chars[GFX_VLINE]);
  printf("%c%c%c%c%c\r\n", gfx_chars[GFX_SDLL], gfx_chars[GFX_DHLINE], gfx_chars[GFX_SDBTEE],
	 gfx_chars[GFX_DHLINE], gfx_chars[GFX_SDLR]);
  printf("\r\n");
  printf("%c%c%c%c%c\r\n", gfx_chars[GFX_DSUL], gfx_chars[GFX_HLINE], gfx_chars[GFX_DSTTEE],
	 gfx_chars[GFX_HLINE], gfx_chars[GFX_DSUR]);
  printf("%c%c%c%c%c\r\n", gfx_chars[GFX_DVLINE], ' ', gfx_chars[GFX_DVLINE],
	 ' ', gfx_chars[GFX_DVLINE]);
  printf("%c%c%c%c%c\r\n", gfx_chars[GFX_DSLTEE], gfx_chars[GFX_HLINE], gfx_chars[GFX_DSPLUS],
	 gfx_chars[GFX_HLINE], gfx_chars[GFX_DSRTEE]);
  printf("%c%c%c%c%c\r\n", gfx_chars[GFX_DVLINE], ' ', gfx_chars[GFX_DVLINE],
	 ' ', gfx_chars[GFX_DVLINE]);
  printf("%c%c%c%c%c\r\n", gfx_chars[GFX_DSLL], gfx_chars[GFX_HLINE], gfx_chars[GFX_DSBTEE],
	 gfx_chars[GFX_HLINE], gfx_chars[GFX_DSLR]);
  send(alternate_off);
  getchar();
#endif
}
