/*
 *	Universal Termcap Terminal Interface -- Internal Declarations
 *
 *	(c) 1997 Martin Mares, <mj@ericsson.cz>
 */

#include "term.h"

/* General declarations */

#include <stdio.h>//debug

void fatal_error(char *, ...);
char *syserr(void);
void *xmalloc(ulg);

#ifdef DEBUG
void debug_print(char *, ...);
#define DBG(x) debug_print x
#else
#define DBG(x)
#endif

#undef TRACE

#ifdef TRACE
#define TR(x...) DBG(x)
#else
//#define TR(x...) fprintf(stderr, x)
#define TR(x...)
#endif

/* Configurable features */

#define TERMLIB_ENABLE_INTR

/* Subincludes */

#include "termcaps.h"

/* Output */

#define FLUSH fflush(stdout)

/* termcap.c */

extern ulg pad_param;
extern char *term_type;

extern int (*send_char)(int);

void do_padding(ulg);
void send_it(char *, ulg);
void sends(char *);
#define send(x) sends(x)
void sendpad(byte *, int);
void senda(byte *, int *);
void sendp(byte *, int, ...);
void init_termcap(void);

/* termclear.c */

int try_cls(void);

/* terminit.c */

extern ulg baud, nsec_per_char, padding_char, term_inited;
extern int use_tabs, overstriking, auto_margins;

#define TABS_NONE 0
#define TABS_NORMAL 1
#define TABS_DESTRUCT 2

#define OS_NONE 0			/* Fortunately no overstriking */
#define OS_SPACE 1			/* Space clears */
#define OS_CLEAR 2			/* Only clearing clears */

#define AM_NONE	0			/* Writing in last column doesn't change cursor position */
#define AM_DUMB 1			/* Always goes to next line */
#define AM_GOTO 2			/* Safe if succeeded by goto or newline */
#define AM_NO_CORNER 3			/* Lower-right corner not refreshed */

struct cost {
  int c0, c1, c2;
};

extern struct cost cost_multi_down, cost_multi_up, cost_multi_left, cost_multi_right, cost_set_column,
                   cost_set_row, cost_move_row, cost_move_col;

extern int cost_home, cost_lower_left, cost_cr, cost_left, cost_right, cost_up, cost_down, cost_nl,
           cost_tab, cost_back_tab, cost_attr_set[8], cost_attr_reset[8], cost_attr_set_all,
           cost_attr_reset_all, cost_set_back, cost_set_fore, cost_clear_n, cost_repeat_char;

void check_caps(void);
void term_setup(void);
void term_clean(void);
void optimizer_setup(void);

/* termios.c */

void get_tios(void);
void set_tios(void);
void restore_tios(void);
void refresh_tios(void);

/* termmap.c */

extern byte *knew, *kold, *cnew, *cold, *anew, *aold, *lfirst, *llast;
extern ulg ltop, lbot;

void darken_all(void);
void init_screen_map(void);
void light(int, int, int, int);

/* termrfsh.c */

void force_redraw(void);

/* termprint.c */

extern int write_r, write_c, write_pos;
extern int ww_r0, ww_r1, ww_c0, ww_c1;

/* termattr.c */

extern byte set_attrs, set_color;	/* Currently set */
extern byte cls_attrs, cls_color;	/* Arguments of last screen clear */
extern byte write_attrs, write_color;	/* We're currently writing with */
extern byte default_color;		/* Terminal default */
extern char *set_attr[8], *reset_attr[8]; /* Control sequences */

#define BACK(c) ((c) >> 4U)
#define FORE(c) ((c) & 15)
#define COLOR(b,f) (((b) << 4) | (f))

void send_attrs(byte, byte);
void force_attrs(byte, byte);
void color_setup(void);
int attr_change_cost(byte, byte, byte, byte, int *);

/* termgfx.c */

extern char *gfx_chars;

void gfx_setup(void);

/* termkeys.c */

void map_key(ulg, byte *);
void map_single_key(ulg, ulg);
void show_key_mappings(void);
void keys_init(void);

/* termmove.c */

extern ulg set_r, set_c;		/* Current physical cursor position */
extern ulg lastc_r, lastc_c;		/* Last cursor mode change */
extern byte set_cm, current_cm;		/* Cursor mode: current and new */

#define NEXT_TAB_STOP(x) (((x)+8) & ~7)
#define PREV_TAB_STOP(x) (((x)-1) & ~7)

void cursor_init(void);
void set_cursor_shape(void);
void cgoto(int, int);
int goto_cost(int, int, int *, int *);
int refresh_move_right_cost(int, int, int, int, int *);
void refresh_do_move_right(int, int, int, int, int);
int refresh_move_left_cost(int, int, int, int, int *);
void refresh_do_move_left(int, int, int, int, int);

/* termscrl.c */

extern byte in_window;
extern ulg win_r0, win_c0, win_r1, win_c1;
extern byte ins_mode;

#define IM_NONE 0
#define IM_INSERT 1
#define IM_DELETE 2

void scroll_init(void);
void reset_window(void);
void set_ins_mode(int);

/* term.c */

extern ulg term_control;

#undef CTRL	/* <sys/ttydefaults.h> defines CTRL with different meaning, but we don't use it */
#define CTRL(x) (term_control & TEC_##x)

/* vcsa.c */

extern int use_vcsa;

void try_vcsa(void);
void vcsa_refresh(void);
void vcsa_goto(int, int);
void vcsa_cleanup(void);
