/*
 *	Universal Terminal Interface -- Screen Map
 *
 *	(c) 1997 Martin Mares, <mj@ericsson.cz>
 */

#include <string.h>

#include "termint.h"

/* Screen map */

byte *knew, *kold;			/* Color map */
byte *anew, *aold;			/* Attribute map */
byte *cnew, *cold;			/* Character map */
byte *lfirst, *llast;			/* First and last modified col in each line */
ulg ltop, lbot;				/* First and last modified line */

void
darken_all(void)
{
  memset(lfirst, 0xff, rows);
  bzero(llast, rows);
  ltop = 0xff;
  lbot = 0;
}

void
init_screen_map(void)
{
  ulg map_size = rows * columns;

  knew = xmalloc(map_size);
  kold = xmalloc(map_size);
  anew = xmalloc(map_size);
  aold = xmalloc(map_size);
  cnew = xmalloc(map_size);
  cold = xmalloc(map_size);
  lfirst = xmalloc(rows);
  llast = xmalloc(rows);

  bzero(aold, map_size);
  bzero(cold, map_size);
  bzero(kold, map_size);
  darken_all();
}

void
light(int r, int c, int h, int w)
{
  int e = c + w - 1;

  if (r < ltop)
    ltop = r;
  while (h--)
    {
      if (c < lfirst[r])
	lfirst[r] = c;
      if (e > llast[r])
	llast[r] = e;
      r++;
    }
  r--;
  if (r > lbot)
    lbot = r;
}
