#ifndef ARCANE__CINFO_H
#define ARCANE__CINFO_H

/*
 * arcane - A rogue-like game engine
 * Copyright (C) 2005  Petr Baudis <pasky@ucw.cz>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <string>

#include "term.h"
#include "util.h"


#define CF_MASK_CLASS	7
#define CF_HUMANOID	0
#define CF_ANIMAL	1
#define CF_ARTIFICIAL	2

#define CF_INVISIBLE	8
#define CF_KARMIC	16
#define CF_IN_PACKS	32
#define CF_UNDERGROUND	64
#define CF_SHARP_AT	128
#define CF_RICH		256
#define CF_INSECT	512 | CF_ANIMAL

struct CreatureInfo {
	char symbol;
	enum Color color;
	const std::string name;
	int height, weight;
	int speed;
	int armor; // only intrisic - skin
	int danger;
	int probability;

	Dice st, dx, to, pe;

	unsigned long flags;

	const std::string description;
};

extern struct CreatureInfo cinfo[];
extern int cinfos;

inline unsigned
creat_prob_in_danger(int m, int danger)
{
	return prob_in_danger(cinfo[m].probability, cinfo[m].danger, danger);
}

#endif
