/*
 * arcane - A rogue-like game engine
 * Copyright (C) 2005  Petr Baudis <pasky@ucw.cz>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <cstdlib>
#include <iostream>
using namespace std;

#include "game.h"
#include "monster.h"
#include "cinfo.h"
#include "uti.h"
#include "mainui.h"


#define VERSION "0.1"


int
main()
{
	cout << "Arcane  " << VERSION << "  (c) Petr Baudis <pasky@ucw.cz>  2005" << endl;

	srand(time(NULL));

	try {
		TermUTI term;
		World world;
		Player player (cinfo[0], world[0], 3, 2); player.get();
		MapObject torch(world[0], 51, 3, '&', COLOR_YELLOW);
		torch.illum_range(7);
		Game game (world, player);

		ui = new MainUI(term, game);
		ui->event_loop();

	} catch (int retval) {
		return retval;
	}

	return 0;
}
