/*
 * arcane - A rogue-like game engine
 * Copyright (C) 2005  Petr Baudis <pasky@ucw.cz>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "level.h"
#include "mapobj.h"
#include "term.h"
#include "util.h"


MapObject::MapObject(Level *level, unsigned x, unsigned y, char symbol, enum Color color)
	: level_(level), x_(x), y_(y), symbol_(symbol), color_(color), illum_range_(0)
{
	visible_ = true;

	if (!level_)
		throw X_badobj();
	(*level_)(x_, y_).enter(this);
}

MapObject::~MapObject()
{
	(*level_)(x_, y_).leave(this);
}

void
MapObject::illum_range(unsigned illum_range)
{
	if (illum_range_ == 0 && illum_range != 0) {
		level_->add_illum(this);
	} else if (illum_range_ != 0 && illum_range == 0) {
		level_->del_illum(this);
	}
	illum_range_ = illum_range;
}


void
MapObject::draw(Term &term, unsigned base_x, unsigned base_y) const
{
	if (!visible_) return;
	term.color(color())
	    .cursor(base_x, base_y)
	    .put(symbol());
}


void
MapObject::move(enum Direction dir)
{
	if (!level_)
		throw X_badobj();

	(*level_)(x_, y_).leave(this);
	level_->in_dir(x_, y_, dir);
	if ((*level_)(x_, y_).type() == Tile::ROCK) {
		level_->in_dir(x_, y_, revdir(dir));
		(*level_)(x_, y_).enter(this);
		throw X_rockdir(dir);
	}
	(*level_)(x_, y_).enter(this);
}
