#ifndef ARCANE__PROP_H
#define ARCANE__PROP_H

/*
 * arcane - A rogue-like game engine
 * Copyright (C) 2005  Petr Baudis <pasky@ucw.cz>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <sstream>
#include <string>

#include "prop.h"

// http://www.codeproject.com/cpp/cppproperties.asp
#if 0

#define READ_ONLY 1
#define WRITE_ONLY 2
#define READ_WRITE 3

template <typename Container, typename ValueType, int nPropType>
    class property
{
public:
    property()
    {
        m_cObject = NULL;
        Set = NULL;
        Get = NULL;
    }

    //-- Set a pointer to the class that contain the property --
    void setContainer(Container* cObject)
    {
        m_cObject = cObject;
    }

    //-- Set the set member function that will change the value --
    void setter(void (Container::*pSet)(ValueType value))
    {
        if((nPropType == WRITE_ONLY) || (nPropType == READ_WRITE))
            Set = pSet;
        else
            Set = NULL;
    }

    //-- Set the get member function that will retrieve the value --
    void getter(ValueType (Container::*pGet)())
    {
        if((nPropType == READ_ONLY) || (nPropType == READ_WRITE))
            Get = pGet;
        else
            Get = NULL;
    }

    //-- Overload the = operator to set the value using the set member --
    ValueType operator =(const ValueType& value)
    {
        assert(m_cObject != NULL);
        assert(Set != NULL);
        (m_cObject->*Set)(value);
        return value;
    }

    //-- Cast the property class to the internal type --
    operator ValueType()
    {
        assert(m_cObject != NULL);
        assert(Get != NULL);
        return (m_cObject->*Get)();
    }

private:
    //-- Pointer to the module that contains the property --
    Container* m_cObject;
    //-- Pointer to set member function --
    void (Container::*Set)(ValueType value);
    //-- Pointer to get member function --
    ValueType (Container::*Get)();};
}

#endif



// I decided the above has really far too much overhead


// atoms

#define PROP_(type, name) private: type name##_;
#define PROP_GET_DECL(type, name) public: type name() const
#define PROP_GET_SIMPLE(type, name, hook) PROP_GET_DECL(type, name) { return name##_; hook }
#define PROP_SET_DECL(type, name) public: void name(type name)
#define PROP_SET_SIMPLE(type, name, hook) PROP_SET_DECL(type, name) { name##_ = name; hook }

// public

#define PROP_WRAPPED(type, name) PROP_(type, name) \
	PROP_GET_DECL(type, name); PROP_SET_DECL(type, name);
#define PROP_WRAPPED_RO(type, name) PROP_(type, name) \
	PROP_GET_DECL(type, name);

#define PROP_SIMPLE(type, name) PROP_(type, name) \
	PROP_GET_SIMPLE(type, name, ;); PROP_SET_SIMPLE(type, name, ;);
#define PROP_SIMPLE_RO(type, name) PROP_(type, name) \
	PROP_GET_SIMPLE(type, name, ;);
#define PROP_SIMPLE_VRO(type, name) PROP_(type, name) \
	PROP_GET_SIMPLE(virtual type, name, ;);
#define PROP_WHOOKED(type, name, hook) PROP_(type, name) \
	PROP_GET_SIMPLE(type, name, ;); PROP_SET_SIMPLE(type, name, hook;);

#endif
