/*
 *	Universal Terminal Interface
 *
 *	(c) 1997 Martin Mares, <mj@ericsson.cz>
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "termint.h"

/* Control flags */

ulg term_control;

/* Main init and cleanup functions */

void
init_terminal(void)
{
  send_char = putchar;
  init_termcap();
  check_caps();
  get_tios();
  set_tios();
  keys_init();			/* Also set up signal handlers */
  term_setup();
  try_vcsa();
  term_inited = 1;
  color_setup();
  gfx_setup();
  optimizer_setup();
  init_screen_map();
  cursor_init();
  scroll_init();
  Tunrestrict();

#ifdef DEBUG
  show_key_mappings();
#endif
}

void
cleanup_terminal(void)
{
  if (term_inited)
    {
      DBG(("Terminal cleanup\n"));
      Tsetcursor(CM_NORMAL);
      set_cursor_shape();
      if (use_vcsa)
	vcsa_cleanup();
      term_clean();
      restore_tios();
      term_inited = 0;
    }
}
