#ifndef ARCANE__ATOMS_H
#define ARCANE__ATOMS_H

/*
 * arcane - A rogue-like game engine
 * Copyright (C) 2005  Petr Baudis <pasky@ucw.cz>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "term.h"

class Refcounted {
public:
	Refcounted();
	virtual ~Refcounted() {}
	virtual Refcounted &get();
	virtual void put();
private:
	int refcount_;
};

inline
Refcounted::Refcounted()
	{ refcount_ = 0; }

inline Refcounted &
Refcounted::get()
	{ refcount_++; return *this; }

inline void
Refcounted::put()
	{ refcount_--; if (refcount_ <= 0) delete this; }


class Drawable : public Refcounted {
public:
	virtual void draw(Term &term, unsigned x, unsigned y) const = 0;
};

class DrawableContainer {
public:
	DrawableContainer(const Drawable *obj, unsigned x, unsigned y)
		: obj_(obj), x_(x), y_(y) { };
	void draw(Term &term, unsigned x0, unsigned y0) const
		{ obj_->draw(term, x0 + x_, y0 + y_); }
private:
	const Drawable *obj_;
	unsigned x_, y_;
};

#endif
