/*
 * arcane - A rogue-like game engine
 * Copyright (C) 2005  Petr Baudis <pasky@ucw.cz>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "cinfo.h"


enum {
	UNIQUE = 0,
	VERY_RARE = 100,
	RARE = 500,
	UNCOMMON = 1000,
	COMMON = 2000,
	VERY_COMMON = 3000,
};


struct CreatureInfo cinfo[] = {
	// sym color        name                        hei  wei  spd  arm  da frequency
	// st       dx       to       pe
	{ '@', COLOR_WHITE, "Adventurer",               175,  75, 100,   1,  4,    RARE,
	  {6,3,4}, {6,3,4}, {6,3,4}, {6,3,4},
	  CF_HUMANOID,
	  "This adventurer left his family, friends, and all his "
	  "previous life to engage on a quest deep under the earth, "
	  "high above the clouds, through frost and flames, to attain "
	  "whatever his goal is - be it glory, wealth, happiness, "
	  "self-recognition or saving the world. The gnarly face, "
	  "strong muscles, firm poise and knowing eye tells about "
	  "what all did the adventurer already saw and overcame."
	},

	{ 'g', COLOR_LIGHTBLUE, "Goblin",               140,  30, 102,   1,  0,  VERY_COMMON,
	  {8,2,3}, {8,3,2}, {4,2,3}, {6,2,2},
	  CF_HUMANOID,
	  "A small deformed creature of thin body, callow hair, "
	  "bad surreptitious eye and ugly smell. The limbs are "
	  "thin and the flesh is scarce, but where there's any, "
	  "it's all strong muscles under pale skin.\n"
	  "You fundamentally feel that you should not trust it "
	  "no matter how friendly face does it wear, still you "
	  "cannot keep yourself from pity for the creature."
	  "So intrisically evil, weak yet strangely desperately "
	  "angry and agressive."
	},

	{ 'g', COLOR_CYAN, "Googol",                    80,  30, 126,   1,  8, UNCOMMON,
	  {8,3,3}, {12,4,3}, {5,2,4}, {12,4,4},
	  CF_ARTIFICIAL,
	  "The head is goblin's, only with bigger skull and "
	  "sharper eyes. But the rest of the body is totally different, "
	  "like if a mad alchemist would take the body of centipede "
	  "and gave it some fresh goblin head. Ninety of small "
	  "feet, tubular body, and ten long-fingered sharp-nailed "
	  "hands dance in front of you, so fast that you can "
	  "barely follow it, and all that headed by the evil will "
	  "and perversed wit of a unusually smart goblin. "
	  "A blink of an eye and the thing is on you and biting "
	  "through your throat, before you realize what's even going on."
	},

	{ 'g', COLOR_LIGHTCYAN, "Geeglo",               60,  35, 141,   1, 15, UNCOMMON,
	  {8,3,4}, {18,4,5}, {7,2,4}, {16,5,4},
	  CF_ARTIFICIAL | CF_INVISIBLE,
	  "This must be some Googol's sinister offspring, even "
	  "more fearsome and deadly dangerous. Its perspicacious "
	  "senses will recognize its victim in the darkest corridor "
	  "but you won't see it even in the brightest room in "
	  "full daylight. Somehow this monster developerd "
	  "an invisible skin while also getting faster, smarter "
	  "and stronger.\n"
	  "Legends are circulating about the deadliness of the poison "
	  "hidden in its ninety feet, although it is not apparent any "
	  "danger could come from the tiny nimble limbs. The steel "
	  "sharpness of the fifty pointy nails is however obvious. "
	  "The skind of the tubular body is somewhat opaque (when "
	  "you can see it at all) and you can see the innards through "
	  "some viscous gelatinous mass, just barely fitting into the body."
	},

	{ 'o', COLOR_LIGHTGREEN, "Orc",                 170,  80, 100,   1,  0,  VERY_COMMON,
	  {8,2,4}, {6,3,2}, {7,4,2}, {6,2,3},
	  CF_HUMANOID,
	  "A medium-sized muscular body covered by briefly "
	  "healed scars, dumb face with thick nose, small eyes "
	  "deep in cromagnon orbits, and mouth corded by "
	  "sharp teeth. The grin, the roar, the sour sweat smell "
	  "all give away unmistakable message: hate and death."
	},

	{ 'o', COLOR_GREEN, "Skurut",                   185,  92, 100,   2,  3,  COMMON,
	  {8,3,4}, {6,3,2}, {8,4,3}, {6,2,3},
	  CF_HUMANOID,
	  "This huge monster does not appear as a quite regular orc. "
	  "The skull is thicker and movements more heavy-handed, "
	  "but do not underestimate the skuruts! Cultivated from "
	  "the toughest of orcs, this is already member of a stronger "
	  "and even more agressive brood. You shall better sharpen your sword."
	},

	{ 'm', COLOR_BLUE, "Maudsee",                    40,  10, 105,   1,  1,  COMMON,
	  {2,1,9}, {14,4,2}, {2,2,2}, {7,2,4},
	  CF_ANIMAL | CF_SHARP_AT | CF_UNDERGROUND | CF_IN_PACKS,
	  "This small furry creature of steel-blue skin, big flappy ears "
	  "and small sharp teeth appears to be like an overgrown mouse, "
	  "harmlessly scurrying through the cavernous corridors getting "
	  "together today's meal. But suddenly, there's more of them, "
	  "wait, many more! And they are climbing up on your legs, and "
	  "their teeth is _SHARP_!"
	},

	{ 'm', COLOR_WHITE, "Karmic maudsee",            40,   1, 105,   1,  4,    RARE,
	  {4,1,9}, {10,4,3}, {4,2,2}, {8,2,4},
	  CF_ANIMAL | CF_SHARP_AT | CF_UNDERGROUND | CF_KARMIC,
	  "This small furry creature of big flappy ears and small sharp "
	  "teeth appears to be like an overgrown mouse, or a maudsee. "
	  "But its skind appears somewhat blurry and seems to reflect "
	  "all colours at once. Your mind glooms as you see it and dark "
	  "presage covers your mind for no apparent reason. The blurry "
	  "rainbow-like skin, the erratic scurrying sounds like if the "
	  "maudsee wouldn't fully touch the ground, the teeth... they "
	  "shouldn't have that color. And they shouldn't be so sharp."
	},

	{ '@', COLOR_BROWN, "Caveman",                  200,  90, 100,   2,  3, UNCOMMON,
	  {8,3,5}, {2,3,3}, {7,4,4}, {4,3,3},
	  CF_HUMANOID,
	  "This massive man of small eyes, big flat nose and thick "
	  "long hair, almost furry and covered in more furs, doesn't "
	  "look too smart. His face conveys the message, though - he "
	  "groans for your blood, and... well, everyone heard the "
	  "rumous... meat for his family. Meet the true warrior of "
	  "the ancient times before the packs evolved to tribes."
	},

	{ 'p', COLOR_LIGHTCYAN, "Pixie",                 80,  20, 102,   1,  2, UNCOMMON,
	  {4,3,3}, {6,3,5}, {5,5,2}, {10,2,12},
	  CF_HUMANOID | CF_RICH,
	  "This tiny mischievous creature keeps cackling, giggling, "
	  "grinning and its purse is always full of coins. It can "
	  "sneak by quietly and you only notice your purse feeling "
	  "lighter suddenly."
	},

	{ 'S', COLOR_GRAY, "Cave spider",                60,   5, 100,   2,  5,   COMMON,
	  {8,3,4}, {8,3,4}, {6,4,4}, {0,4,2},
	  CF_INSECT | CF_UNDERGROUND,
	  "The massive round body tingled by stone grey (or is it only "
	  "the color or does the skin also appear rather... hard?), "
	  "with a pair of eyes well covered by thick laps of skin. "
	  "Its six thin long legs slowly moves the body towards you, "
	  "prepared to trap you in its webs and melt you with the "
	  "acidic fluids."
	},

#if 0
	{ 'c', COLOR_LIGHTBLUE, "Dragon-fly",            10,   1, 120,  0,    RARE,
	  {7,2,2}, {16,2,8}, {2,2,2}, {9,2,3},
	  CF_INSECT,
	  "This insect originally lived in "
	},
#endif

#if 0
	{ 'd', COLOR_GRAY, "Wolf",                      100,  35, 105,  1, UNCOMMON,
	  {},
	  CF_ANIMAL | CF_SHARP_AT | CF_NO_UNDERGROUND, CF_IN_PACKS,
	},
#endif
};

int cinfos = sizeof(cinfo) / sizeof(cinfo[0]);
