#ifndef ARCANE__GAME_H
#define ARCANE__GAME_H

/*
 * arcane - A rogue-like game engine
 * Copyright (C) 2005  Petr Baudis <pasky@ucw.cz>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "atoms.h"
#include "level.h"
#include "player.h"
#include "world.h"

class Game {
public:
	Game(World &world, Player &player);

	void tick();

	std::list<DrawableContainer *> draw_queue;

	PROP_SIMPLE_RO(World &, world);
	PROP_SIMPLE_RO(Level *, curlevel);
	PROP_SIMPLE_RO(Player &, player);

protected:
};


inline
Game::Game(World &world, Player &player)
	: world_(world), player_(player)
{
	curlevel_ = Game::player().level();
}

#endif
