/*
 * arcane - A rogue-like game engine
 * Copyright (C) 2005  Petr Baudis <pasky@ucw.cz>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "iinfo.h"


enum {
	UNIQUE = 0,
	VERY_RARE = 100,
	RARE = 500,
	UNCOMMON = 1000,
	COMMON = 2000,
	VERY_COMMON = 3000,
};


struct ItemInfo iinfo[] = {
	// type       color        name                        wei  da frequency
	{ ITT_FOOD,   COLOR_WHITE, "bone",                       5,  0,   VERY_COMMON,
	  IF_IN_HEAPS,
	  "An old bone of some creature less successful than you (so far)."
	},

	{ ITT_FOOD,   COLOR_BROWN, "iron ration",              200,  0,   COMMON,
	  0,
	  "To last you through the hardest times."
	},

	{ ITT_POTION,  COLOR_BLUE, "watery potion",              5,  3,   COMMON,
	  0,
	  "Pure and apparently drinkable water."
	},

	{ ITT_SCROLL, COLOR_WHITE, "blank scroll",               1,  4,     RARE,
	  0,
	  "An empty white scroll."
	},
};

int iinfos = sizeof(iinfo) / sizeof(iinfo[0]);
