#ifndef ARCANE__IINFO_H
#define ARCANE__IINFO_H

/*
 * arcane - A rogue-like game engine
 * Copyright (C) 2005  Petr Baudis <pasky@ucw.cz>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <string>

#include "term.h"
#include "util.h"


#define IF_IN_HEAPS	1
#define IF_UNDERGROUND	2

enum ItemType {
	ITT_FOOD = '%',
	ITT_POTION = '!',
	ITT_SCROLL = '?',
};

struct ItemInfo {
	enum ItemType type;
	enum Color color;
	const std::string name;
	int weight;
	int danger;
	int probability;

	unsigned long flags;

	const std::string description;
};

extern struct ItemInfo iinfo[];
extern int iinfos;

inline unsigned
item_prob_in_danger(int m, int danger)
{
	return prob_in_danger(iinfo[m].probability, iinfo[m].danger, danger);
}

#endif
