/*
 * arcane - A rogue-like game engine
 * Copyright (C) 2005  Petr Baudis <pasky@ucw.cz>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "item.h"
#include "level.h"
#include "term.h"


Item::Item(ItemInfo &iinfo)
	: iinfo_(iinfo)
{
	type_ = iinfo.type;
	color_ = iinfo.color;
	weight_ = iinfo.weight;
}

void
Item::draw(Term &term, unsigned x, unsigned y) const
{
	term.color(color())
	    .cursor(x, y)
	    .put(char(type()));
}


ItemOnMap::ItemOnMap(Item *item, Level *level, unsigned x, unsigned y)
	: MapObject(level, x, y, '+', COLOR_GREEN), item_(item)
{
	symbol(char(item->type()));
	color(item->color());
	weight_ = item->weight();
	item->get();
}

ItemOnMap *
ItemOnMap::corporealize_random(ItemInfo &iinfo, Level *level)
{
	unsigned x, y;
	do { level->randpos(x, y); } while ((*level)(x, y).occupied());

	Item *i = new Item(iinfo);
	ItemOnMap *m = new ItemOnMap(i, level, x, y);
	m->get();
	return m;
}

ItemOnMap *
ItemOnMap::corporealize_nearby(ItemInfo &iinfo, MapObject &whom, Level *level)
{
	unsigned x, y; int dx, dy;
	do {
		level->randpos(x, y);
		dx = (x - whom.x()); dx *= dx;
		dy = (y - whom.y()); dy *= dy;
	} while ((*level)(x, y).occupied() || (rand(4*(dx + dy))));

	Item *i = new Item(iinfo);
	ItemOnMap *m = new ItemOnMap(i, level, x, y);
	m->get();
	return m;
}
