#ifndef ARCANE__MAINUI_H
#define ARCANE__MAINUI_H

/*
 * arcane - A rogue-like game engine
 * Copyright (C) 2005  Petr Baudis <pasky@ucw.cz>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "game.h"
#include "term.h"

// TODO: Generic UI class for things like selectors, help, etc.
class MainUI {
public:
	MainUI(Term &term, Game &game);
	void render() const;
	void event_loop();

	void msg(const std::string &str);

private:
	Term &term_;
	Game &game_;

	std::string msgbuf;
};

extern class MainUI *ui;


inline
MainUI::MainUI(Term &term, Game &game)
	: term_(term), game_(game)
{
}

#endif
