#ifndef ARCANE__MONSTER_H
#define ARCANE__MONSTER_H

/*
 * arcane - A rogue-like game engine
 * Copyright (C) 2005  Petr Baudis <pasky@ucw.cz>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "creature.h"
#include "game.h"
#include "level.h"


class Monster: public Creature {
public:
	Monster(CreatureInfo &cinfo, Level *level, unsigned x, unsigned y);
	static Monster *spawn_random(CreatureInfo &cinfo, Level *level);
	static Monster *spawn_nearby(CreatureInfo &cinfo, MapObject &whom, Level *level);

	virtual void move(enum Direction dir);

	virtual void tick(Game &game);

	virtual bool player() const { return false; }
};

#endif
