/*
 * arcane - A rogue-like game engine
 * Copyright (C) 2005  Petr Baudis <pasky@ucw.cz>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <cstdio>

#include "game.h"
#include "creature.h"
#include "mainui.h"
#include "player.h"
#include "term.h"


Player::Player(CreatureInfo &cinfo, Level *level, unsigned x, unsigned y)
	: Creature(cinfo, level, x, y)
{
	illum_range(4);
}

void
Player::draw(Term &term, unsigned base_x, unsigned base_y) const
{
	Creature::draw(term, base_x, base_y);
	term.input_location(base_x, base_y);
}

void
Player::tick(Game &game)
{
	Creature::tick(game);

	std::list<Creature *> encounters;
	encounters = level()->explore(x(), y(), visible_range());

#if 0
	for (std::list<Creature *>::const_iterator obj = encounters.begin();
	     obj != encounters.end(); obj++) {
		unsigned x = (*obj)->x(), y = (*obj)->y();
		DrawableContainer *d = new DrawableContainer(*obj, x, y);
		game.draw_queue.push_back(d);
	}
#endif
}

void
Player::move(enum Direction dir)
{
	try {
		Creature::move(dir);
	} catch (class Creature::X_creatdir x) {
		std::string msg;
		fight(*this, *x.c, msg, FF_NORMAL);
		ui->msg(msg);
	}
}

void
Player::die(std::string &msg)
{
	msg += ". You die.";
	ui->msg(msg);
	ui->render();
	throw 0;
}
