/*
 * arcane - A rogue-like game engine
 * Copyright (C) 2005  Petr Baudis <pasky@ucw.cz>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <string>
using namespace std;

#include "term.h"
#include "util.h"


Term &
Term::put(char ch)
{
	std::string str (1, ch);
	return put(str);
}

Term &
Term::put(long num, int width)
{
	return put(tostr(num, width));
}
Term &
Term::put(unsigned long num, int width)
{
	return put(tostr(num, width));
}
Term &
Term::put(int num, int width)
{
	return put(tostr(num, width));
}


std::string &
Term::get(std::string &str)
{
	Key key;

	str.clear();
	while (get(key) != KEY_ENTER) {
		switch (key) {
		case KEY_BACKSPACE:
			backspace();
			str.erase(str.end()-1);
			break;
		case KEY_ESCAPE:
			str.clear();
			return str;
		default:
			// XXX
			char ch = (char) (key & 0xFF);
			put(ch);
			str.push_back(ch);
			break;
		}
	}

	return str;
}

int &
Term::get(long &num)
{
	// TODO
	throw;
}

int &
Term::get(unsigned long &num)
{
	// TODO
	throw;
}

int &
Term::get(int &num)
{
	// TODO
	throw;
}

bool &
Term::get(bool &b)
{
	// TODO
	throw;
}
