#ifndef ARCANE__TERMdUTI_H
#define ARCANE__TERMdUTI_H

/*
 * arcane - A rogue-like game engine
 * Copyright (C) 2005  Petr Baudis <pasky@ucw.cz>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <string>

#include "term.h"


class TermUTI: public Term {
public:
	TermUTI();
	~TermUTI();

	TermUTI &color(enum Color fg, enum Color bg = COLOR_ANY);
	TermUTI &cursor(int x, int y);

	TermUTI &put(const std::string str);
	TermUTI &clear(int x1, int y1, int x2, int y2);

	Key &get(Key &ch);

	int width();
	int height();

protected:
	void backspace();

private:
	void setcolor(enum Color fg, enum Color bg);
};


#endif
