/*
 *	Universal Termcap Terminal Interface
 *
 *	(c) 1997 Martin Mares, <mj@ericsson.cz>
 */

#ifndef UTI__TERM_H
#define UTI__TERM_H

#ifdef __cplusplus
extern "C" {
#endif

#include "uti/termenum.h"

typedef unsigned char byte;
typedef unsigned short word;
typedef unsigned int ulg;

extern ulg rows, columns;
extern ulg supported_attrs;
extern int num_colors, num_real_colors;

void init_terminal(void);
void cleanup_terminal(void);
void Tcls(void);
void Trefresh(void);
void Tredraw(void);
void Tgoto(int, int);
void Tsetcursor(int);
void Trestrict(int, int, int, int);
void Tunrestrict(void);
void Tputc(int);
void Tputg(int);
void Tputs(const char *);
void Tputt(int);
void Tbell(void);
void Tsetattr(ulg, ulg, ulg);
void Tphysattr(ulg, ulg, ulg);
void Tclear(int, int, int, int);
void Tfill(int, int, int, int, word);
void Tshadow(int, int, int, int);
void Tmove(int, int, int, int, int, int);
void Tscroll(int, int, int, int, int, int);
void Tinsert(int, int, int, byte *);
void *Tsmap_alloc(int, int);
void Tsmap_free(void *);
void Tsmap_put(void *, int, int, int, int, int, int);
void Tsmap_get(void *, int, int, int, int, int, int);
ulg Tgetkey(void);
void Tclean(void);

/* Control flags */

extern ulg term_control;

#ifdef __cplusplus
}
#endif

#endif
