/*
 *	Universal Terminal Interface -- Blitting Functions
 *
 *	(c) 1997 Martin Mares, <mj@ericsson.cz>
 */

#include <stdlib.h>

#include "termint.h"

struct smap {
  int w, h;
  byte *cmap, *amap, *kmap;
};

void *
Tsmap_alloc(int h, int w)
{
  struct smap *s = xmalloc(sizeof(struct smap));
  int z = h * w;

  s->h = h;
  s->w = w;
  s->cmap = xmalloc(z);
  s->amap = xmalloc(z);
  s->kmap = xmalloc(z);
  return s;
}

void
Tsmap_free(void *smap)
{
  struct smap *s = smap;

  free(s->cmap);
  free(s->amap);
  free(s->kmap);
  free(s);
}

void
Tsmap_get(void *smap, int r, int c, int h, int w, int rr, int cc)
{
  struct smap *s = smap;
  int p, q;

  light(r, c, h, w);
  p = r * columns + c;
  q = rr * s->w + cc;
  while (h--)
    {
      memcpy(cnew + p, s->cmap + q, w);
      memcpy(anew + p, s->amap + q, w);
      memcpy(knew + p, s->kmap + q, w);
      p += columns;
      q += s->w;
    }
}

void
Tsmap_put(void *smap, int r, int c, int h, int w, int rr, int cc)
{
  struct smap *s = smap;
  int p, q;

  p = r * columns + c;
  q = rr * s->w + cc;
  while (h--)
    {
      memcpy(s->cmap + q, cnew + p, w);
      memcpy(s->amap + q, anew + p, w);
      memcpy(s->kmap + q, knew + p, w);
      p += columns;
      q += s->w;
    }
}
