/*
 *	Universal Termcap Terminal Interface
 *
 *	(c) 1997 Martin Mares, <mj@ericsson.cz>
 */

#ifndef UTI__TERMENUM_H
#define UTI__TERMENUM_H

#ifdef __cplusplus
extern "C" {
#endif

enum uti_attr {
	ATTR_UNDERLINE = 1,
	ATTR_ITALIC = 2,
	ATTR_SHADOW = 4,
	ATTR_BRIGHT = 8,
	ATTR_DIM = 16,
	ATTR_STANDOUT = 32,
	ATTR_INVERSE = 64,
	ATTR_ALTERNATE = 128,  /* Don't relocate */
};

enum uti_ai {
	AI_UNDERLINE = 0,
	AI_ITALIC = 1,
	AI_SHADOW = 2,
	AI_BRIGHT = 3,
	AI_DIM = 4,
	AI_STANDOUT = 5,
	AI_INVERSE = 6,
	AI_ALTERNATE = 7,
};

enum uti_cm {
	CM_FOLLOWMASK = 3,  /* Tsetcursor parameter */
	CM_FOLLOW = 0,
	CM_FIXED = 1,
	CM_SHAPEMASK = 12,
	CM_NORMAL = 0,
	CM_ENHANCED = 4,
	CM_INVISIBLE = 8,
};

enum uti_gfx {
	GFX_UL = 0,
	GFX_LL = 1,
	GFX_UR = 2,
	GFX_LR = 3,
	GFX_LTEE = 4,
	GFX_RTEE = 5,
	GFX_BTEE = 6,
	GFX_TTEE = 7,
	GFX_HLINE = 8,
	GFX_VLINE = 9,
	GFX_PLUS = 10,
	GFX_HILINE = 11,
	GFX_LOLINE = 12,
	GFX_DIAMOND = 13,
	GFX_CKBOARD = 14,
	GFX_DEGREE = 15,
	GFX_PLMINUS = 16,
	GFX_BULLET = 17,
	GFX_LARROW = 18,
	GFX_RARROW = 19,
	GFX_DARROW = 20,
	GFX_UARROW = 21,
	GFX_BOARD = 22,
	GFX_LANTERN = 23,
	GFX_BLOCK = 24,
	GFX_DUL = 25,
	GFX_DLL = 26,
	GFX_DUR = 27,
	GFX_DLR = 28,
	GFX_DLTEE = 29,
	GFX_DRTEE = 30,
	GFX_DBTEE = 31,
	GFX_DTTEE = 32,
	GFX_DHLINE = 33,
	GFX_DVLINE = 34,
	GFX_DPLUS = 35,
	GFX_DSPLUS = 36,
	GFX_SDPLUS = 37,
	GFX_DSLTEE = 38,
	GFX_DSRTEE = 39,
	GFX_DSBTEE = 40,
	GFX_DSTTEE = 41,
	GFX_SDLTEE = 42,
	GFX_SDRTEE = 43,
	GFX_SDBTEE = 44,
	GFX_SDTTEE = 45,
	GFX_DSUL = 46,
	GFX_DSLL = 47,
	GFX_DSUR = 48,
	GFX_DSLR = 49,
	GFX_SDUL = 50,
	GFX_SDLL = 51,
	GFX_SDUR = 52,
	GFX_SDLR = 53,
};

/* Control flags */

enum uti_tec {
	TEC_NO_CURSOR_OPT = 1,
	TEC_MOVE_ALWAYS_REDRAWS = 2,
	TEC_SCROLL_ALWAYS_REDRAWS = 4,
	TEC_NO_PC_GRAPHICS = 8,
	TEC_NO_VT_GRAPHICS = 0x10,
	TEC_NO_COLORS = 0x20,
	TEC_IMMEDIATE = 0x40,
	TEC_NO_TERMIOS_CHECK = 0x80,
	TEC_NO_GETWINSZ = 0x100,
	TEC_EMULATE_CLS = 0x200,
	TEC_FAKE_SCREEN_SIZE = 0x400,
	TEC_NO_GOTO_REFRESH = 0x800,
	TEC_NO_VCSA = 0x1000,
};

/* Key codes */

enum uti_keys {
	KEY_BASE = 0x1000,

	KEY_UPPER_LEFT = (KEY_BASE+0),
	KEY_UPPER_RIGHT = (KEY_BASE+1),
	KEY_CENTER = (KEY_BASE+2),
	KEY_BACKSPACE = (KEY_BASE+3),
	KEY_BACKTAB = (KEY_BASE+4),
	KEY_LOWER_LEFT = (KEY_BASE+5),
	KEY_LOWER_RIGHT = (KEY_BASE+6),
	KEY_DELETE = (KEY_BASE+7),
	KEY_DOWN = (KEY_BASE+8),
	KEY_INSERT_TOGGLE_DUMMY = (KEY_BASE+9),
	KEY_END = (KEY_BASE+10),
	KEY_ENTER = (KEY_BASE+11),
	KEY_EXIT = (KEY_BASE+12),
	KEY_F0 = (KEY_BASE+13),
	KEY_F1 = (KEY_BASE+14),
	KEY_F2 = (KEY_BASE+15),
	KEY_F3 = (KEY_BASE+16),
	KEY_F4 = (KEY_BASE+17),
	KEY_F5 = (KEY_BASE+18),
	KEY_F6 = (KEY_BASE+19),
	KEY_F7 = (KEY_BASE+20),
	KEY_F8 = (KEY_BASE+21),
	KEY_F9 = (KEY_BASE+22),
	KEY_F10 = (KEY_BASE+23),
	KEY_HELP = (KEY_BASE+24),
	KEY_HOME = (KEY_BASE+25),
	KEY_INSERT = (KEY_BASE+26),
	KEY_LEFT = (KEY_BASE+27),
	KEY_NEXT_PAGE = (KEY_BASE+28),
	KEY_PREV_PAGE = (KEY_BASE+29),
	KEY_RIGHT = (KEY_BASE+30),
	KEY_UP = (KEY_BASE+31),

	KEY_ESCAPE = (KEY_BASE+100),
	KEY_UNKNOWN = (KEY_BASE+101),
	KEY_TAB = (KEY_BASE+102),

	KEY_INTERRUPT = (KEY_BASE+200), /* These never get to the user */
	KEY_QUIT = (KEY_BASE+201),
	KEY_ERASE = (KEY_BASE+202),
	KEY_SUSPEND = (KEY_BASE+203),
	KEY_WERASE = (KEY_BASE+204),
	KEY_EOF = (KEY_BASE+205),
	KEY_REFRESH = (KEY_BASE+206),

	META = 0x4000,
};

#ifdef __cplusplus
}
#endif

#endif
