/*
 * Decompiled with CFR 0.152.
 */
package opennlp.maxent;

import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectIntProcedure;
import java.util.Collections;
import java.util.List;
import opennlp.maxent.ComparableEvent;
import opennlp.maxent.DataIndexer;

public abstract class AbstractDataIndexer
implements DataIndexer {
    protected int[][] contexts;
    protected int[] outcomeList;
    protected int[] numTimesEventsSeen;
    protected String[] predLabels;
    protected String[] outcomeLabels;

    public int[][] getContexts() {
        return this.contexts;
    }

    public int[] getNumTimesEventsSeen() {
        return this.numTimesEventsSeen;
    }

    public int[] getOutcomeList() {
        return this.outcomeList;
    }

    public String[] getPredLabels() {
        return this.predLabels;
    }

    public String[] getOutcomeLabels() {
        return this.outcomeLabels;
    }

    protected void sortAndMerge(List list) {
        int n;
        Collections.sort(list);
        int n2 = list.size();
        int n3 = 1;
        if (n2 <= 1) {
            return;
        }
        ComparableEvent comparableEvent = (ComparableEvent)list.get(0);
        for (n = 1; n < n2; ++n) {
            ComparableEvent comparableEvent2 = (ComparableEvent)list.get(n);
            if (comparableEvent.compareTo(comparableEvent2) == 0) {
                ++comparableEvent.seen;
                list.set(n, null);
                continue;
            }
            comparableEvent = comparableEvent2;
            ++n3;
        }
        System.out.println("done. Reduced " + n2 + " events to " + n3 + ".");
        this.contexts = new int[n3][];
        this.outcomeList = new int[n3];
        this.numTimesEventsSeen = new int[n3];
        int n4 = 0;
        for (n = 0; n < n2; ++n) {
            ComparableEvent comparableEvent3 = (ComparableEvent)list.get(n);
            if (null == comparableEvent3) continue;
            this.numTimesEventsSeen[n4] = comparableEvent3.seen;
            this.outcomeList[n4] = comparableEvent3.outcome;
            this.contexts[n4] = comparableEvent3.predIndexes;
            ++n4;
        }
    }

    protected static String[] toIndexedStringArray(TObjectIntHashMap tObjectIntHashMap) {
        final String[] stringArray = new String[tObjectIntHashMap.size()];
        tObjectIntHashMap.forEachEntry(new TObjectIntProcedure(){

            public boolean execute(Object object, int n) {
                stringArray[n] = (String)object;
                return true;
            }
        });
        return stringArray;
    }
}

