/*
 * Decompiled with CFR 0.152.
 */
package opennlp.maxent;

import opennlp.maxent.DataIndexer;
import opennlp.maxent.EventStream;
import opennlp.maxent.GISModel;
import opennlp.maxent.MutableContext;
import opennlp.maxent.OnePassDataIndexer;

class GISTrainer {
    private boolean _simpleSmoothing = false;
    private boolean _useSlackParameter = false;
    private double sigma = 2.0;
    private double _smoothingObservation = 0.1;
    private boolean printMessages = false;
    private int numTokens;
    private int numPreds;
    private int numOutcomes;
    private int TID;
    private int PID;
    private int OID;
    private int[][] contexts;
    private int[] outcomes;
    private int[] outcomeList;
    private int[] numTimesEventsSeen;
    private String[] outcomeLabels;
    private String[] predLabels;
    private MutableContext[] observedExpects;
    private MutableContext[] params;
    private MutableContext[] modelExpects;
    private int constant;
    private double constantInverse;
    private double correctionParam;
    private double cfObservedExpect;
    private double CFMOD;
    private final double NEAR_ZERO = 0.01;
    private final double LLThreshold = 1.0E-4;
    double[] modelDistribution;
    int[] numfeats;
    double iprob;

    GISTrainer() {
    }

    GISTrainer(boolean bl) {
        this();
        this.printMessages = bl;
    }

    public void setSmoothing(boolean bl) {
        this._simpleSmoothing = bl;
    }

    public void setSmoothingObservation(double d) {
        this._smoothingObservation = d;
    }

    public GISModel trainModel(EventStream eventStream, int n, int n2) {
        return this.trainModel(n, new OnePassDataIndexer(eventStream, n2));
    }

    public GISModel trainModel(int n, DataIndexer dataIndexer) {
        int n2;
        this.display("Incorporating indexed data for training...  \n");
        this.contexts = dataIndexer.getContexts();
        this.outcomes = dataIndexer.getOutcomeList();
        this.numTimesEventsSeen = dataIndexer.getNumTimesEventsSeen();
        this.numTokens = this.contexts.length;
        this.constant = this.contexts[0].length;
        this.TID = 1;
        while (this.TID < this.contexts.length) {
            if (this.contexts[this.TID].length > this.constant) {
                this.constant = this.contexts[this.TID].length;
            }
            ++this.TID;
        }
        this.constantInverse = 1.0 / (double)this.constant;
        this.display("done.\n");
        this.outcomeLabels = dataIndexer.getOutcomeLabels();
        this.outcomeList = dataIndexer.getOutcomeList();
        this.numOutcomes = this.outcomeLabels.length;
        this.iprob = Math.log(1.0 / (double)this.numOutcomes);
        this.predLabels = dataIndexer.getPredLabels();
        this.numPreds = this.predLabels.length;
        this.display("\tNumber of Event Tokens: " + this.numTokens + "\n");
        this.display("\t    Number of Outcomes: " + this.numOutcomes + "\n");
        this.display("\t  Number of Predicates: " + this.numPreds + "\n");
        int[][] nArray = new int[this.numPreds][this.numOutcomes];
        this.TID = 0;
        while (this.TID < this.numTokens) {
            for (int i = 0; i < this.contexts[this.TID].length; ++i) {
                int[] nArray2 = nArray[this.contexts[this.TID][i]];
                int n3 = this.outcomeList[this.TID];
                nArray2[n3] = nArray2[n3] + this.numTimesEventsSeen[this.TID];
            }
            ++this.TID;
        }
        dataIndexer = null;
        double d = this._smoothingObservation;
        this.params = new MutableContext[this.numPreds];
        this.modelExpects = new MutableContext[this.numPreds];
        this.observedExpects = new MutableContext[this.numPreds];
        int[] nArray3 = new int[this.numOutcomes];
        int[] nArray4 = new int[this.numOutcomes];
        this.OID = 0;
        while (this.OID < this.numOutcomes) {
            nArray4[this.OID] = this.OID;
            ++this.OID;
        }
        int n4 = 0;
        this.PID = 0;
        while (this.PID < this.numPreds) {
            int[] nArray5;
            n4 = 0;
            if (this._simpleSmoothing) {
                n4 = this.numOutcomes;
                nArray5 = nArray4;
            } else {
                this.OID = 0;
                while (this.OID < this.numOutcomes) {
                    if (nArray[this.PID][this.OID] > 0) {
                        nArray3[n4] = this.OID;
                        ++n4;
                    }
                    ++this.OID;
                }
                if (n4 == this.numOutcomes) {
                    nArray5 = nArray4;
                } else {
                    nArray5 = new int[n4];
                    for (n2 = 0; n2 < n4; ++n2) {
                        nArray5[n2] = nArray3[n2];
                    }
                }
            }
            this.params[this.PID] = new MutableContext(nArray5, new double[n4]);
            this.modelExpects[this.PID] = new MutableContext(nArray5, new double[n4]);
            this.observedExpects[this.PID] = new MutableContext(nArray5, new double[n4]);
            for (n2 = 0; n2 < n4; ++n2) {
                this.OID = nArray5[n2];
                this.params[this.PID].setParameter(n2, 0.0);
                this.modelExpects[this.PID].setParameter(n2, 0.0);
                if (nArray[this.PID][this.OID] > 0) {
                    this.observedExpects[this.PID].setParameter(n2, nArray[this.PID][this.OID]);
                    continue;
                }
                if (!this._simpleSmoothing) continue;
                this.observedExpects[this.PID].setParameter(n2, d);
            }
            ++this.PID;
        }
        if (this._useSlackParameter) {
            n2 = 0;
            this.TID = 0;
            while (this.TID < this.numTokens) {
                for (int i = 0; i < this.contexts[this.TID].length; ++i) {
                    this.PID = this.contexts[this.TID][i];
                    if (this.modelExpects[this.PID].contains(this.outcomes[this.TID])) continue;
                    n2 += this.numTimesEventsSeen[this.TID];
                }
                n2 += (this.constant - this.contexts[this.TID].length) * this.numTimesEventsSeen[this.TID];
                ++this.TID;
            }
            this.cfObservedExpect = n2 == 0 ? Math.log(0.01) : Math.log(n2);
            this.correctionParam = 0.0;
        }
        nArray = null;
        this.display("...done.\n");
        this.modelDistribution = new double[this.numOutcomes];
        this.numfeats = new int[this.numOutcomes];
        this.display("Computing model parameters...\n");
        this.findParameters(n);
        return new GISModel(this.params, this.predLabels, this.outcomeLabels, this.constant, this.correctionParam);
    }

    private void findParameters(int n) {
        double d = 0.0;
        double d2 = 0.0;
        this.display("Performing " + n + " iterations.\n");
        for (int i = 1; i <= n; ++i) {
            if (i < 10) {
                this.display("  " + i + ":  ");
            } else if (i < 100) {
                this.display(" " + i + ":  ");
            } else {
                this.display(i + ":  ");
            }
            d2 = this.nextIteration();
            if (i > 1) {
                if (d > d2) {
                    System.err.println("Model Diverging: loglikelihood decreased");
                    break;
                }
                if (d2 - d < 1.0E-4) break;
            }
            d = d2;
        }
        this.observedExpects = null;
        this.modelExpects = null;
        this.numTimesEventsSeen = null;
        this.contexts = null;
    }

    public void eval(int[] nArray, double[] dArray) {
        int n;
        for (int i = 0; i < this.numOutcomes; ++i) {
            dArray[i] = this.iprob;
            this.numfeats[i] = 0;
        }
        for (int i = 0; i < nArray.length; ++i) {
            MutableContext mutableContext = this.params[nArray[i]];
            int[] nArray2 = mutableContext.getOutcomes();
            double[] dArray2 = mutableContext.getParameters();
            for (n = 0; n < nArray2.length; ++n) {
                int n2;
                int n3 = n2 = nArray2[n];
                this.numfeats[n3] = this.numfeats[n3] + 1;
                int n4 = n2;
                dArray[n4] = dArray[n4] + this.constantInverse * dArray2[n];
            }
        }
        double d = 0.0;
        for (n = 0; n < this.numOutcomes; ++n) {
            dArray[n] = Math.exp(dArray[n]);
            if (this._useSlackParameter) {
                int n5 = n;
                dArray[n5] = dArray[n5] + (1.0 - (double)this.numfeats[n] / (double)this.constant) * this.correctionParam;
            }
            d += dArray[n];
        }
        n = 0;
        while (n < this.numOutcomes) {
            int n6 = n++;
            dArray[n6] = dArray[n6] / d;
        }
    }

    private double nextIteration() {
        Object[] objectArray;
        double d = 0.0;
        this.CFMOD = 0.0;
        int n = 0;
        int n2 = 0;
        this.TID = 0;
        while (this.TID < this.numTokens) {
            int n3;
            this.eval(this.contexts[this.TID], this.modelDistribution);
            for (n3 = 0; n3 < this.contexts[this.TID].length; ++n3) {
                this.PID = this.contexts[this.TID][n3];
                objectArray = this.modelExpects[this.PID].getOutcomes();
                for (int i = 0; i < objectArray.length; ++i) {
                    this.OID = (int)objectArray[i];
                    this.modelExpects[this.PID].updateParameter(i, this.modelDistribution[this.OID] * (double)this.numTimesEventsSeen[this.TID]);
                }
                if (!this._useSlackParameter) continue;
                this.OID = 0;
                while (this.OID < this.numOutcomes) {
                    if (!this.modelExpects[this.PID].contains(this.OID)) {
                        this.CFMOD += this.modelDistribution[this.OID] * (double)this.numTimesEventsSeen[this.TID];
                    }
                    ++this.OID;
                }
            }
            if (this._useSlackParameter) {
                this.CFMOD += (double)((this.constant - this.contexts[this.TID].length) * this.numTimesEventsSeen[this.TID]);
            }
            d += Math.log(this.modelDistribution[this.outcomes[this.TID]]) * (double)this.numTimesEventsSeen[this.TID];
            n += this.numTimesEventsSeen[this.TID];
            if (this.printMessages) {
                n3 = 0;
                this.OID = 1;
                while (this.OID < this.numOutcomes) {
                    if (this.modelDistribution[this.OID] > this.modelDistribution[n3]) {
                        n3 = this.OID;
                    }
                    ++this.OID;
                }
                if (n3 == this.outcomes[this.TID]) {
                    n2 += this.numTimesEventsSeen[this.TID];
                }
            }
            ++this.TID;
        }
        this.display(".");
        this.PID = 0;
        while (this.PID < this.numPreds) {
            double[] dArray = this.observedExpects[this.PID].getParameters();
            objectArray = this.modelExpects[this.PID].getParameters();
            int[] nArray = this.params[this.PID].getOutcomes();
            for (int i = 0; i < nArray.length; ++i) {
                this.params[this.PID].updateParameter(i, Math.log(dArray[i]) - Math.log(objectArray[i]));
                this.modelExpects[this.PID].setParameter(i, 0.0);
            }
            ++this.PID;
        }
        if (this.CFMOD > 0.0 && this._useSlackParameter) {
            this.correctionParam += this.cfObservedExpect - Math.log(this.CFMOD);
        }
        this.display(". loglikelihood=" + d + "\t" + (double)n2 / (double)n + "\n");
        return d;
    }

    private void display(String string) {
        if (this.printMessages) {
            System.out.print(string);
        }
    }
}

