/*
 * Decompiled with CFR 0.152.
 */
package opennlp.maxent;

import gnu.getopt.Getopt;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import opennlp.maxent.Evalable;
import opennlp.maxent.Event;
import opennlp.maxent.EventCollectorAsStream;
import opennlp.maxent.EventStream;
import opennlp.maxent.GIS;
import opennlp.maxent.GISModel;
import opennlp.maxent.MaxentModel;
import opennlp.maxent.io.SuffixSensitiveGISModelReader;
import opennlp.maxent.io.SuffixSensitiveGISModelWriter;

public class TrainEval {
    public static void eval(MaxentModel maxentModel, Reader reader, Evalable evalable) {
        TrainEval.eval(maxentModel, reader, evalable, false);
    }

    public static void eval(MaxentModel maxentModel, Reader reader, Evalable evalable, boolean bl) {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        Event[] eventArray = evalable.getEventCollector(reader).getEvents(true);
        String string = evalable.getNegativeOutcome();
        for (int i = 0; i < eventArray.length; ++i) {
            String string2 = maxentModel.getBestOutcome(maxentModel.eval(eventArray[i].getContext()));
            String string3 = eventArray[i].getOutcome();
            if (bl) {
                System.out.println(string3 + " " + string2);
            }
            if (!string3.equals(string)) {
                f += 1.0f;
            }
            if (!string2.equals(string) && !string2.equals(string3)) {
                f3 += 1.0f;
                continue;
            }
            if (!string3.equals(string2)) continue;
            f2 += 1.0f;
        }
        System.out.println("Precision: " + f2 / (f2 + f3));
        System.out.println("Recall:    " + f2 / f);
    }

    public static MaxentModel train(EventStream eventStream, int n) {
        return GIS.trainModel(eventStream, 100, n);
    }

    public static void run(String[] stringArray, Evalable evalable) throws IOException {
        int n;
        String string = "./";
        String string2 = "maxent";
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        Getopt getopt = new Getopt("maxent", stringArray, "d:s:c:tvl");
        while ((n = getopt.getopt()) != -1) {
            switch (n) {
                case 100: {
                    string = getopt.getOptarg() + "/";
                    break;
                }
                case 115: {
                    string2 = getopt.getOptarg();
                    break;
                }
                case 99: {
                    n2 = Integer.parseInt(getopt.getOptarg());
                    break;
                }
                case 116: {
                    bl = true;
                    break;
                }
                case 108: {
                    bl3 = true;
                    break;
                }
                case 118: {
                    bl2 = true;
                }
            }
        }
        int n3 = getopt.getOptind();
        if (n3 >= stringArray.length) {
            System.out.println("This is a usage message from opennlp.maxent.TrainEval. You have called the training procedure for a maxent application with the incorrect arguments.  These are the options:");
            System.out.println("\nOptions for defining the model location and name:");
            System.out.println(" -d <directoryName>");
            System.out.println("\tThe directory in which to store the model.");
            System.out.println(" -s <modelName>");
            System.out.println("\tThe name of the model, e.g. EnglishPOS.bin.gz or NameFinder.txt.");
            System.out.println("\nOptions for training:");
            System.out.println(" -c <cutoff>");
            System.out.println("\tAn integer cutoff level to reduce infrequent contextual predicates.");
            System.out.println(" -t\tTrain a model. If absent, the given model will be loaded and evaluated.");
            System.out.println("\nOptions for evaluation:");
            System.out.println(" -l\t the evaluation method of class that uses the model. If absent, TrainEval's eval method is used.");
            System.out.println(" -v\t verbose.");
            System.out.println("\nThe final argument is the data file to be loaded and used for either training or evaluation.");
            System.out.println("\nAs an example for training:\n java opennlp.grok.preprocess.postag.POSTaggerME -t -d ./ -s EnglishPOS.bin.gz -c 7 postag.data");
            System.exit(0);
        }
        FileReader fileReader = new FileReader(stringArray[n3]);
        if (bl) {
            MaxentModel maxentModel = TrainEval.train(new EventCollectorAsStream(evalable.getEventCollector(fileReader)), n2);
            new SuffixSensitiveGISModelWriter((GISModel)maxentModel, new File(string + string2)).persist();
        } else {
            GISModel gISModel = new SuffixSensitiveGISModelReader(new File(string + string2)).getModel();
            if (bl3) {
                evalable.localEval(gISModel, fileReader, evalable, bl2);
            } else {
                TrainEval.eval(gISModel, fileReader, evalable, bl2);
            }
        }
    }
}

