/*
 * Decompiled with CFR 0.152.
 */
package opennlp.maxent.io;

import java.io.IOException;
import java.util.StringTokenizer;
import opennlp.maxent.Context;
import opennlp.maxent.GISModel;

public abstract class GISModelReader {
    protected int NUM_PREDS;

    protected abstract int readInt() throws IOException;

    protected abstract double readDouble() throws IOException;

    protected abstract String readUTF() throws IOException;

    public GISModel getModel() throws IOException {
        this.checkModelType();
        int n = this.getCorrectionConstant();
        double d = this.getCorrectionParameter();
        String[] stringArray = this.getOutcomes();
        int[][] nArray = this.getOutcomePatterns();
        String[] stringArray2 = this.getPredicates();
        Context[] contextArray = this.getParameters(nArray);
        return new GISModel(contextArray, stringArray2, stringArray, n, d);
    }

    protected void checkModelType() throws IOException {
        String string = this.readUTF();
        if (!string.equals("GIS")) {
            System.out.println("Error: attempting to load a " + string + " model as a GIS model." + " You should expect problems.");
        }
    }

    protected int getCorrectionConstant() throws IOException {
        return this.readInt();
    }

    protected double getCorrectionParameter() throws IOException {
        return this.readDouble();
    }

    protected String[] getOutcomes() throws IOException {
        int n = this.readInt();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.readUTF();
        }
        return stringArray;
    }

    protected int[][] getOutcomePatterns() throws IOException {
        int n = this.readInt();
        int[][] nArrayArray = new int[n][];
        for (int i = 0; i < n; ++i) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.readUTF(), " ");
            int[] nArray = new int[stringTokenizer.countTokens()];
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                nArray[n2] = Integer.parseInt(stringTokenizer.nextToken());
                ++n2;
            }
            nArrayArray[i] = nArray;
        }
        return nArrayArray;
    }

    protected String[] getPredicates() throws IOException {
        this.NUM_PREDS = this.readInt();
        String[] stringArray = new String[this.NUM_PREDS];
        for (int i = 0; i < this.NUM_PREDS; ++i) {
            stringArray[i] = this.readUTF();
        }
        return stringArray;
    }

    protected Context[] getParameters(int[][] nArray) throws IOException {
        Context[] contextArray = new Context[this.NUM_PREDS];
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            int n2;
            int[] nArray2 = new int[nArray[i].length - 1];
            for (n2 = 1; n2 < nArray[i].length; ++n2) {
                nArray2[n2 - 1] = nArray[i][n2];
            }
            for (n2 = 0; n2 < nArray[i][0]; ++n2) {
                double[] dArray = new double[nArray[i].length - 1];
                for (int j = 1; j < nArray[i].length; ++j) {
                    dArray[j - 1] = this.readDouble();
                }
                contextArray[n] = new Context(nArray2, dArray);
                ++n;
            }
        }
        return contextArray;
    }
}

