/*
 * Decompiled with CFR 0.152.
 */
package opennlp.maxent;

import java.text.DecimalFormat;
import opennlp.maxent.Context;
import opennlp.maxent.MaxentModel;
import opennlp.maxent.TIntParamHashMap;
import opennlp.maxent.TObjectIndexHashMap;

public final class GISModel
implements MaxentModel {
    private final Context[] params;
    private final TObjectIndexHashMap pmap;
    private final String[] ocNames;
    private final double correctionConstant;
    private final double correctionParam;
    private final int numOutcomes;
    private final double iprob;
    private final double fval;
    private DecimalFormat df;
    private int[] numfeats;

    public GISModel(Context[] contextArray, String[] stringArray, String[] stringArray2, int n, double d) {
        this.pmap = new TObjectIndexHashMap(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            this.pmap.put(stringArray[i], i);
        }
        this.params = contextArray;
        this.ocNames = stringArray2;
        this.correctionConstant = n;
        this.correctionParam = d;
        this.numOutcomes = this.ocNames.length;
        this.iprob = Math.log(1.0 / (double)this.numOutcomes);
        this.fval = 1.0 / this.correctionConstant;
        this.numfeats = new int[this.numOutcomes];
    }

    private static Context[] convertToContexts(TIntParamHashMap[] tIntParamHashMapArray) {
        Context[] contextArray = new Context[tIntParamHashMapArray.length];
        for (int i = 0; i < tIntParamHashMapArray.length; ++i) {
            int[] nArray = tIntParamHashMapArray[i].keys();
            double[] dArray = new double[nArray.length];
            for (int j = 0; j < dArray.length; ++j) {
                dArray[j] = tIntParamHashMapArray[i].get(nArray[j]);
            }
            contextArray[i] = new Context(nArray, dArray);
        }
        return contextArray;
    }

    public final double[] eval(String[] stringArray) {
        return this.eval(stringArray, new double[this.numOutcomes]);
    }

    public final double[] eval(String[] stringArray, double[] dArray) {
        int n;
        int n2;
        for (n2 = 0; n2 < this.numOutcomes; ++n2) {
            dArray[n2] = this.iprob;
            this.numfeats[n2] = 0;
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            int n3 = this.pmap.get(stringArray[n2]);
            if (n3 < 0) continue;
            Context context = this.params[n3];
            int[] nArray = context.getOutcomes();
            double[] dArray2 = context.getParameters();
            for (int i = 0; i < nArray.length; ++i) {
                int n4;
                int n5 = n4 = nArray[i];
                this.numfeats[n5] = this.numfeats[n5] + 1;
                int n6 = n4;
                dArray[n6] = dArray[n6] + dArray2[i];
            }
        }
        double d = 0.0;
        for (n = 0; n < this.numOutcomes; ++n) {
            dArray[n] = Math.exp(dArray[n] * this.fval + (1.0 - (double)this.numfeats[n] / this.correctionConstant) * this.correctionParam);
            d += dArray[n];
        }
        n = 0;
        while (n < this.numOutcomes) {
            int n7 = n++;
            dArray[n7] = dArray[n7] / d;
        }
        return dArray;
    }

    public final String getBestOutcome(double[] dArray) {
        int n = 0;
        for (int i = 1; i < dArray.length; ++i) {
            if (!(dArray[i] > dArray[n])) continue;
            n = i;
        }
        return this.ocNames[n];
    }

    public final String getAllOutcomes(double[] dArray) {
        if (dArray.length != this.ocNames.length) {
            return "The double array sent as a parameter to GISModel.getAllOutcomes() must not have been produced by this model.";
        }
        if (this.df == null) {
            this.df = new DecimalFormat("0.0000");
        }
        StringBuffer stringBuffer = new StringBuffer(dArray.length * 2);
        stringBuffer.append(this.ocNames[0]).append("[").append(this.df.format(dArray[0])).append("]");
        for (int i = 1; i < dArray.length; ++i) {
            stringBuffer.append("  ").append(this.ocNames[i]).append("[").append(this.df.format(dArray[i])).append("]");
        }
        return stringBuffer.toString();
    }

    public final String getOutcome(int n) {
        return this.ocNames[n];
    }

    public int getIndex(String string) {
        for (int i = 0; i < this.ocNames.length; ++i) {
            if (!this.ocNames[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    public int getNumOutcomes() {
        return this.numOutcomes;
    }

    public final Object[] getDataStructures() {
        Object[] objectArray = new Object[]{this.params, this.pmap, this.ocNames, new Integer((int)this.correctionConstant), new Double(this.correctionParam)};
        return objectArray;
    }
}

