/*
 * Decompiled with CFR 0.152.
 */
package opennlp.maxent;

import gnu.trove.TIntArrayList;
import gnu.trove.TLinkedList;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import opennlp.maxent.AbstractDataIndexer;
import opennlp.maxent.ComparableEvent;
import opennlp.maxent.Event;
import opennlp.maxent.EventStream;

public class OnePassDataIndexer
extends AbstractDataIndexer {
    public OnePassDataIndexer(EventStream eventStream) {
        this(eventStream, 0);
    }

    public OnePassDataIndexer(EventStream eventStream, int n) {
        TObjectIntHashMap tObjectIntHashMap = new TObjectIntHashMap();
        System.out.println("Indexing events using cutoff of " + n + "\n");
        System.out.print("\tComputing event counts...  ");
        TLinkedList tLinkedList = this.computeEventCounts(eventStream, tObjectIntHashMap, n);
        System.out.println("done. " + tLinkedList.size() + " events");
        System.out.print("\tIndexing...  ");
        List list = this.index(tLinkedList, tObjectIntHashMap);
        tLinkedList = null;
        tObjectIntHashMap = null;
        System.out.println("done.");
        System.out.print("Sorting and merging events... ");
        this.sortAndMerge(list);
        System.out.println("Done indexing.");
    }

    private TLinkedList computeEventCounts(EventStream eventStream, TObjectIntHashMap tObjectIntHashMap, int n) {
        TObjectIntHashMap tObjectIntHashMap2 = new TObjectIntHashMap();
        TLinkedList tLinkedList = new TLinkedList();
        int n2 = 0;
        while (eventStream.hasNext()) {
            Event event = eventStream.nextEvent();
            tLinkedList.addLast((Object)event);
            String[] stringArray = event.getContext();
            for (int i = 0; i < stringArray.length; ++i) {
                if (tObjectIntHashMap.containsKey((Object)stringArray[i])) continue;
                if (!tObjectIntHashMap2.increment((Object)stringArray[i])) {
                    tObjectIntHashMap2.put((Object)stringArray[i], 1);
                }
                if (tObjectIntHashMap2.get((Object)stringArray[i]) < n) continue;
                tObjectIntHashMap.put((Object)stringArray[i], n2++);
                tObjectIntHashMap2.remove((Object)stringArray[i]);
            }
        }
        tObjectIntHashMap.trimToSize();
        return tLinkedList;
    }

    private List index(TLinkedList tLinkedList, TObjectIntHashMap tObjectIntHashMap) {
        TObjectIntHashMap tObjectIntHashMap2 = new TObjectIntHashMap();
        int n = tLinkedList.size();
        int n2 = 0;
        boolean bl = false;
        ArrayList<ComparableEvent> arrayList = new ArrayList<ComparableEvent>(n);
        TIntArrayList tIntArrayList = new TIntArrayList();
        for (int i = 0; i < n; ++i) {
            int n3;
            Event event = (Event)((Object)tLinkedList.removeFirst());
            String[] stringArray = event.getContext();
            String string = event.getOutcome();
            if (tObjectIntHashMap2.containsKey((Object)string)) {
                n3 = tObjectIntHashMap2.get((Object)string);
            } else {
                n3 = n2++;
                tObjectIntHashMap2.put((Object)string, n3);
            }
            for (int j = 0; j < stringArray.length; ++j) {
                String string2 = stringArray[j];
                if (!tObjectIntHashMap.containsKey((Object)string2)) continue;
                tIntArrayList.add(tObjectIntHashMap.get((Object)string2));
            }
            if (tIntArrayList.size() > 0) {
                ComparableEvent comparableEvent = new ComparableEvent(n3, tIntArrayList.toNativeArray());
                arrayList.add(comparableEvent);
            } else {
                System.err.println("Dropped event " + event.getOutcome() + ":" + Arrays.asList(event.getContext()));
            }
            tIntArrayList.resetQuick();
        }
        this.outcomeLabels = OnePassDataIndexer.toIndexedStringArray(tObjectIntHashMap2);
        this.predLabels = OnePassDataIndexer.toIndexedStringArray(tObjectIntHashMap);
        return arrayList;
    }
}

