/*
 * Decompiled with CFR 0.152.
 */
package opennlp.maxent;

import gnu.trove.TIntArrayList;
import gnu.trove.TObjectIntHashMap;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import opennlp.maxent.AbstractDataIndexer;
import opennlp.maxent.ComparableEvent;
import opennlp.maxent.Event;
import opennlp.maxent.EventStream;
import opennlp.maxent.FileEventStream;

public class TwoPassDataIndexer
extends AbstractDataIndexer {
    public TwoPassDataIndexer(EventStream eventStream) {
        this(eventStream, 0);
    }

    public TwoPassDataIndexer(EventStream eventStream, int n) {
        TObjectIntHashMap tObjectIntHashMap = new TObjectIntHashMap();
        System.out.println("Indexing events using cutoff of " + n + "\n");
        System.out.print("\tComputing event counts...  ");
        try {
            File file = File.createTempFile("events", null);
            file.deleteOnExit();
            int n2 = this.computeEventCounts(eventStream, new FileWriter(file), tObjectIntHashMap, n);
            System.out.println("done. " + n2 + " events");
            System.out.print("\tIndexing...  ");
            List list = this.index(n2, new FileEventStream(file), tObjectIntHashMap);
            tObjectIntHashMap = null;
            file.delete();
            System.out.println("done.");
            System.out.print("Sorting and merging events... ");
            this.sortAndMerge(list);
            System.out.println("Done indexing.");
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    private int computeEventCounts(EventStream eventStream, Writer writer, TObjectIntHashMap tObjectIntHashMap, int n) throws IOException {
        TObjectIntHashMap tObjectIntHashMap2 = new TObjectIntHashMap();
        int n2 = 0;
        int n3 = 0;
        while (eventStream.hasNext()) {
            Event event = eventStream.nextEvent();
            ++n3;
            writer.write(FileEventStream.toLine(event));
            String[] stringArray = event.getContext();
            for (int i = 0; i < stringArray.length; ++i) {
                if (tObjectIntHashMap.containsKey((Object)stringArray[i])) continue;
                if (!tObjectIntHashMap2.increment((Object)stringArray[i])) {
                    tObjectIntHashMap2.put((Object)stringArray[i], 1);
                }
                if (tObjectIntHashMap2.get((Object)stringArray[i]) < n) continue;
                tObjectIntHashMap.put((Object)stringArray[i], n2++);
                tObjectIntHashMap2.remove((Object)stringArray[i]);
            }
        }
        tObjectIntHashMap.trimToSize();
        writer.close();
        return n3;
    }

    private List index(int n, EventStream eventStream, TObjectIntHashMap tObjectIntHashMap) {
        TObjectIntHashMap tObjectIntHashMap2 = new TObjectIntHashMap();
        int n2 = 0;
        ArrayList<ComparableEvent> arrayList = new ArrayList<ComparableEvent>(n);
        TIntArrayList tIntArrayList = new TIntArrayList();
        while (eventStream.hasNext()) {
            int n3;
            Event event = eventStream.nextEvent();
            String[] stringArray = event.getContext();
            String string = event.getOutcome();
            if (tObjectIntHashMap2.containsKey((Object)string)) {
                n3 = tObjectIntHashMap2.get((Object)string);
            } else {
                n3 = n2++;
                tObjectIntHashMap2.put((Object)string, n3);
            }
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                if (!tObjectIntHashMap.containsKey((Object)string2)) continue;
                tIntArrayList.add(tObjectIntHashMap.get((Object)string2));
            }
            if (tIntArrayList.size() > 0) {
                ComparableEvent comparableEvent = new ComparableEvent(n3, tIntArrayList.toNativeArray());
                arrayList.add(comparableEvent);
            } else {
                System.err.println("Dropped event " + event.getOutcome() + ":" + Arrays.asList(event.getContext()));
            }
            tIntArrayList.resetQuick();
        }
        this.outcomeLabels = TwoPassDataIndexer.toIndexedStringArray(tObjectIntHashMap2);
        this.predLabels = TwoPassDataIndexer.toIndexedStringArray(tObjectIntHashMap);
        return arrayList;
    }
}

