/*
 * Decompiled with CFR 0.152.
 */
package opennlp.maxent.io;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.GZIPOutputStream;
import opennlp.maxent.GISModel;
import opennlp.maxent.io.GISModelWriter;

public class BinaryGISModelWriter
extends GISModelWriter {
    DataOutputStream output;

    public BinaryGISModelWriter(GISModel gISModel, File file) throws IOException {
        super(gISModel);
        this.output = file.getName().endsWith(".gz") ? new DataOutputStream(new GZIPOutputStream(new FileOutputStream(file))) : new DataOutputStream(new FileOutputStream(file));
    }

    public BinaryGISModelWriter(GISModel gISModel, DataOutputStream dataOutputStream) {
        super(gISModel);
        this.output = dataOutputStream;
    }

    protected void writeUTF(String string) throws IOException {
        this.output.writeUTF(string);
    }

    protected void writeInt(int n) throws IOException {
        this.output.writeInt(n);
    }

    protected void writeDouble(double d) throws IOException {
        this.output.writeDouble(d);
    }

    protected void close() throws IOException {
        this.output.flush();
        this.output.close();
    }
}

