/*
 * Decompiled with CFR 0.152.
 */
package opennlp.maxent.io;

import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.zip.GZIPOutputStream;
import opennlp.maxent.GISModel;
import opennlp.maxent.io.BinaryGISModelWriter;
import opennlp.maxent.io.GISModelWriter;
import opennlp.maxent.io.PlainTextGISModelWriter;

public class SuffixSensitiveGISModelWriter
extends GISModelWriter {
    private final GISModelWriter suffixAppropriateWriter;

    public SuffixSensitiveGISModelWriter(GISModel gISModel, File file) throws IOException {
        super(gISModel);
        FilterOutputStream filterOutputStream;
        String string = file.getName();
        if (string.endsWith(".gz")) {
            filterOutputStream = new GZIPOutputStream(new FileOutputStream(file));
            string = string.substring(0, string.length() - 3);
        } else {
            filterOutputStream = new DataOutputStream(new FileOutputStream(file));
        }
        this.suffixAppropriateWriter = string.endsWith(".bin") ? new BinaryGISModelWriter(gISModel, new DataOutputStream(filterOutputStream)) : new PlainTextGISModelWriter(gISModel, new BufferedWriter(new OutputStreamWriter(filterOutputStream)));
    }

    protected void writeUTF(String string) throws IOException {
        this.suffixAppropriateWriter.writeUTF(string);
    }

    protected void writeInt(int n) throws IOException {
        this.suffixAppropriateWriter.writeInt(n);
    }

    protected void writeDouble(double d) throws IOException {
        this.suffixAppropriateWriter.writeDouble(d);
    }

    protected void close() throws IOException {
        this.suffixAppropriateWriter.close();
    }
}

