/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.shef.wit.simmetrics;

import java.text.DecimalFormat;
import java.util.ArrayList;
import uk.ac.shef.wit.simmetrics.arbitrators.InterfaceMetricArbitrator;
import uk.ac.shef.wit.simmetrics.arbitrators.MeanMetricArbitrator;
import uk.ac.shef.wit.simmetrics.metrichandlers.MetricHandler;
import uk.ac.shef.wit.simmetrics.similaritymetrics.InterfaceStringMetric;

public final class TestArbitrators {
    private static final String string1 = "Sam J Chapman";
    private static final String string2 = "Samuel Chapman";
    private static final String string3 = "S Chapman";
    private static final String string4 = "Samuel John Chapman";
    private static final String string5 = "John Smith";
    private static final String string6 = "Richard Smith";
    private static final String string7 = "aaaa mnop zzzz";
    private static final String string8 = "bbbb mnop yyyy";
    private static final String string9 = "aa mnop zzzzzz";
    private static final String string10 = "a";
    private static final String string11 = "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa";
    private static final String string12 = "aaaaa bcdefgh mmmmmmmm stuvwx zzzzzz";
    private static final String string13 = "jjjjj bcdefgh qqqqqqqq stuvwx yyyyyy";
    private static final String string14 = "aaaaa bcdefgh stuvwx zzzzzz";
    private static final String string15 = "aaaaa aaaaa aaaaa zzzzzz";
    private static final String string16 = "aaaaa aaaaa";
    private static final String[][] testCases = new String[][]{{"Sam J Chapman", "Samuel Chapman"}, {"Sam J Chapman", "S Chapman"}, {"Samuel Chapman", "S Chapman"}, {"Sam J Chapman", "Sam J Chapman"}, {"Samuel John Chapman", "John Smith"}, {"John Smith", "Richard Smith"}, {"John Smith", "Sam J Chapman"}, {"Sam J Chapman", "Richard Smith"}, {"Sam J Chapman", "Samuel John Chapman"}, {"Samuel Chapman", "Samuel John Chapman"}, {"aaaa mnop zzzz", "bbbb mnop yyyy"}, {"aaaa mnop zzzz", "aa mnop zzzzzz"}, {"bbbb mnop yyyy", "aa mnop zzzzzz"}, {"a", "a"}, {"aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"}, {"a", "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"}, {"aaaaa bcdefgh mmmmmmmm stuvwx zzzzzz", "jjjjj bcdefgh qqqqqqqq stuvwx yyyyyy"}, {"aaaaa bcdefgh mmmmmmmm stuvwx zzzzzz", "aaaaa bcdefgh stuvwx zzzzzz"}, {"aaaaa bcdefgh stuvwx zzzzzz", "aaaaa aaaaa aaaaa zzzzzz"}, {"aaaaa aaaaa", "aaaaa aaaaa"}};

    public static void main(String[] args) {
        ArrayList<String> metricStrings = MetricHandler.GetMetricsAvailable();
        ArrayList<InterfaceStringMetric> testMetricArrayList = new ArrayList<InterfaceStringMetric>();
        for (String metricString : metricStrings) {
            testMetricArrayList.add(MetricHandler.createMetric(metricString));
        }
        MeanMetricArbitrator arbitrator = new MeanMetricArbitrator();
        arbitrator.setArbitrationMetrics(testMetricArrayList);
        TestArbitrators.testMethod(arbitrator);
    }

    private static void testMethod(InterfaceMetricArbitrator arbitrator) {
        System.out.println("Performing Arbitrartion with: " + arbitrator.getShortDescriptionString());
        System.out.println("Using the Following Test Cases:");
        for (int i = 0; i < testCases.length; ++i) {
            System.out.println("t" + (i + 1) + " \"" + testCases[i][0] + "\" vs \"" + testCases[i][1] + "\"");
        }
        System.out.println();
        DecimalFormat df = new DecimalFormat("0.00");
        for (String[] testCase : testCases) {
            float result = arbitrator.getArbitrationScore(testCase[0], testCase[1]);
            System.out.println(df.format(result) + " for \"" + testCase[0] + "\" vs \"" + testCase[1] + "\"");
        }
    }
}

