/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.shef.wit.simmetrics.similaritymetrics;

import uk.ac.shef.wit.simmetrics.similaritymetrics.InterfaceStringMetric;

public abstract class AbstractStringMetric
implements InterfaceStringMetric {
    public abstract String getShortDescriptionString();

    public abstract String getLongDescriptionString();

    public abstract String getSimilarityExplained(String var1, String var2);

    public final long getSimilarityTimingActual(String string1, String string2) {
        long timeBefore = System.currentTimeMillis();
        this.getSimilarity(string1, string2);
        long timeAfter = System.currentTimeMillis();
        return timeAfter - timeBefore;
    }

    public final float[] batchCompareSet(String[] set, String comparator) {
        float[] results = new float[set.length];
        for (int strNum = 0; strNum < set.length; ++strNum) {
            results[strNum] = this.getSimilarity(set[strNum], comparator);
        }
        return results;
    }

    public final float[] batchCompareSets(String[] firstSet, String[] secondSet) {
        float[] results = firstSet.length <= secondSet.length ? new float[firstSet.length] : new float[secondSet.length];
        for (int strNum = 0; strNum < results.length; ++strNum) {
            results[strNum] = this.getSimilarity(firstSet[strNum], secondSet[strNum]);
        }
        return results;
    }

    public abstract float getSimilarityTimingEstimated(String var1, String var2);

    public abstract float getSimilarity(String var1, String var2);

    public abstract float getUnNormalisedSimilarity(String var1, String var2);
}

