/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.shef.wit.simmetrics.similaritymetrics;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import uk.ac.shef.wit.simmetrics.similaritymetrics.AbstractStringMetric;
import uk.ac.shef.wit.simmetrics.tokenisers.InterfaceTokeniser;
import uk.ac.shef.wit.simmetrics.tokenisers.TokeniserWhitespace;

public final class BlockDistance
extends AbstractStringMetric
implements Serializable {
    private final float ESTIMATEDTIMINGCONST = 6.445714E-5f;
    private final InterfaceTokeniser tokeniser;

    public BlockDistance() {
        this.tokeniser = new TokeniserWhitespace();
    }

    public BlockDistance(InterfaceTokeniser tokeniserToUse) {
        this.tokeniser = tokeniserToUse;
    }

    public String getShortDescriptionString() {
        return "BlockDistance";
    }

    public String getLongDescriptionString() {
        return "Implements the Block distance algorithm whereby vector space block distance is used to determine a similarity";
    }

    public String getSimilarityExplained(String string1, String string2) {
        return null;
    }

    public float getSimilarityTimingEstimated(String string1, String string2) {
        float str1Tokens = this.tokeniser.tokenizeToArrayList(string1).size();
        float str2Tokens = this.tokeniser.tokenizeToArrayList(string2).size();
        return ((str1Tokens + str2Tokens) * str1Tokens + (str1Tokens + str2Tokens) * str2Tokens) * 6.445714E-5f;
    }

    public float getSimilarity(String string1, String string2) {
        ArrayList<String> str1Tokens = this.tokeniser.tokenizeToArrayList(string1);
        ArrayList<String> str2Tokens = this.tokeniser.tokenizeToArrayList(string2);
        float totalPossible = str1Tokens.size() + str2Tokens.size();
        float totalDistance = this.getUnNormalisedSimilarity(string1, string2);
        return (totalPossible - totalDistance) / totalPossible;
    }

    public float getUnNormalisedSimilarity(String string1, String string2) {
        ArrayList<String> str1Tokens = this.tokeniser.tokenizeToArrayList(string1);
        ArrayList<String> str2Tokens = this.tokeniser.tokenizeToArrayList(string2);
        HashSet<String> allTokens = new HashSet<String>();
        allTokens.addAll(str1Tokens);
        allTokens.addAll(str2Tokens);
        int totalDistance = 0;
        for (Object e : allTokens) {
            String sToken;
            String token = (String)e;
            int countInString1 = 0;
            int countInString2 = 0;
            for (String str1Token : str1Tokens) {
                sToken = str1Token;
                if (!sToken.equals(token)) continue;
                ++countInString1;
            }
            for (String str2Token : str2Tokens) {
                sToken = str2Token;
                if (!sToken.equals(token)) continue;
                ++countInString2;
            }
            if (countInString1 > countInString2) {
                totalDistance += countInString1 - countInString2;
                continue;
            }
            totalDistance += countInString2 - countInString1;
        }
        return totalDistance;
    }
}

