/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.shef.wit.simmetrics.similaritymetrics;

import java.io.Serializable;
import uk.ac.shef.wit.simmetrics.math.MathFuncs;
import uk.ac.shef.wit.simmetrics.similaritymetrics.AbstractStringMetric;
import uk.ac.shef.wit.simmetrics.similaritymetrics.costfunctions.AbstractSubstitutionCost;
import uk.ac.shef.wit.simmetrics.similaritymetrics.costfunctions.SubCost1_Minus2;

public final class SmithWaterman
extends AbstractStringMetric
implements Serializable {
    private final float ESTIMATEDTIMINGCONST = 1.61E-4f;
    private AbstractSubstitutionCost dCostFunc;
    private float gapCost;

    public SmithWaterman() {
        this.gapCost = 0.5f;
        this.dCostFunc = new SubCost1_Minus2();
    }

    public SmithWaterman(float costG) {
        this.gapCost = costG;
        this.dCostFunc = new SubCost1_Minus2();
    }

    public SmithWaterman(float costG, AbstractSubstitutionCost costFunc) {
        this.gapCost = costG;
        this.dCostFunc = costFunc;
    }

    public SmithWaterman(AbstractSubstitutionCost costFunc) {
        this.gapCost = 0.5f;
        this.dCostFunc = costFunc;
    }

    public float getGapCost() {
        return this.gapCost;
    }

    public void setGapCost(float gapCost) {
        this.gapCost = gapCost;
    }

    public AbstractSubstitutionCost getdCostFunc() {
        return this.dCostFunc;
    }

    public void setdCostFunc(AbstractSubstitutionCost dCostFunc) {
        this.dCostFunc = dCostFunc;
    }

    public String getShortDescriptionString() {
        return "SmithWaterman";
    }

    public String getLongDescriptionString() {
        return "Implements the Smith-Waterman algorithm providing a similarity measure between two string";
    }

    public String getSimilarityExplained(String string1, String string2) {
        return null;
    }

    public float getSimilarityTimingEstimated(String string1, String string2) {
        float str1Length = string1.length();
        float str2Length = string2.length();
        return (str1Length * str2Length + str1Length + str2Length) * 1.61E-4f;
    }

    public float getSimilarity(String string1, String string2) {
        float smithWaterman = this.getUnNormalisedSimilarity(string1, string2);
        float maxValue = Math.min(string1.length(), string2.length());
        maxValue = this.dCostFunc.getMaxCost() > -this.gapCost ? (maxValue *= this.dCostFunc.getMaxCost()) : (maxValue *= -this.gapCost);
        if (maxValue == 0.0f) {
            return 1.0f;
        }
        return smithWaterman / maxValue;
    }

    public float getUnNormalisedSimilarity(String s, String t) {
        int j;
        float cost;
        int i;
        int n = s.length();
        int m = t.length();
        if (n == 0) {
            return m;
        }
        if (m == 0) {
            return n;
        }
        float[][] d = new float[n][m];
        float maxSoFar = 0.0f;
        for (i = 0; i < n; ++i) {
            cost = this.dCostFunc.getCost(s, i, t, 0);
            if (i == 0) {
                d[0][0] = MathFuncs.max3(0.0f, -this.gapCost, cost);
            } else {
                d[i][0] = MathFuncs.max3(0.0f, d[i - 1][0] - this.gapCost, cost);
            }
            if (!(d[i][0] > maxSoFar)) continue;
            maxSoFar = d[i][0];
        }
        for (j = 0; j < m; ++j) {
            cost = this.dCostFunc.getCost(s, 0, t, j);
            if (j == 0) {
                d[0][0] = MathFuncs.max3(0.0f, -this.gapCost, cost);
            } else {
                d[0][j] = MathFuncs.max3(0.0f, d[0][j - 1] - this.gapCost, cost);
            }
            if (!(d[0][j] > maxSoFar)) continue;
            maxSoFar = d[0][j];
        }
        for (i = 1; i < n; ++i) {
            for (j = 1; j < m; ++j) {
                cost = this.dCostFunc.getCost(s, i, t, j);
                d[i][j] = MathFuncs.max4(0.0f, d[i - 1][j] - this.gapCost, d[i][j - 1] - this.gapCost, d[i - 1][j - 1] + cost);
                if (!(d[i][j] > maxSoFar)) continue;
                maxSoFar = d[i][j];
            }
        }
        return maxSoFar;
    }
}

