/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.shef.wit.simmetrics.tokenisers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import uk.ac.shef.wit.simmetrics.tokenisers.InterfaceTokeniser;
import uk.ac.shef.wit.simmetrics.wordhandlers.DummyStopTermHandler;
import uk.ac.shef.wit.simmetrics.wordhandlers.InterfaceTermHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TokeniserWhitespace
implements InterfaceTokeniser,
Serializable {
    private InterfaceTermHandler stopWordHandler = new DummyStopTermHandler();
    private final String delimiters = "\r\n\t \u00a0";

    @Override
    public final String getShortDescriptionString() {
        return "TokeniserWhitespace";
    }

    @Override
    public final String getDelimiters() {
        return "\r\n\t \u00a0";
    }

    @Override
    public InterfaceTermHandler getStopWordHandler() {
        return this.stopWordHandler;
    }

    @Override
    public void setStopWordHandler(InterfaceTermHandler stopWordHandler) {
        this.stopWordHandler = stopWordHandler;
    }

    @Override
    public final ArrayList<String> tokenizeToArrayList(String input) {
        ArrayList<String> returnVect = new ArrayList<String>();
        int curPos = 0;
        while (curPos < input.length()) {
            char ch = input.charAt(curPos);
            if (Character.isWhitespace(ch)) {
                ++curPos;
            }
            int nextGapPos = input.length();
            for (int i = 0; i < "\r\n\t \u00a0".length(); ++i) {
                int testPos = input.indexOf("\r\n\t \u00a0".charAt(i), curPos);
                if (testPos >= nextGapPos || testPos == -1) continue;
                nextGapPos = testPos;
            }
            String term = input.substring(curPos, nextGapPos);
            if (!this.stopWordHandler.isWord(term) && !term.trim().equals("")) {
                returnVect.add(term);
            }
            curPos = nextGapPos;
        }
        return returnVect;
    }

    @Override
    public Set<String> tokenizeToSet(String input) {
        HashSet<String> returnSet = new HashSet<String>();
        returnSet.addAll(this.tokenizeToArrayList(input));
        return returnSet;
    }
}

