/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.nlp.wikipedia;

import edu.jhu.nlp.wikipedia.InfoBox;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WikiTextParser {
    private String wikiText = null;
    private Vector<String> pageCats = null;
    private Vector<String> pageLinks = null;
    private boolean redirect = false;
    private String redirectString = null;
    private static Pattern redirectPattern = Pattern.compile("#REDIRECT\\s+\\[\\[(.*?)\\]\\]");
    private boolean stub = false;
    private boolean disambiguation = false;
    private static Pattern stubPattern = Pattern.compile("\\-stub\\}\\}");
    private static Pattern disambCatPattern = Pattern.compile("\\{\\{disambig\\}\\}");
    private InfoBox infoBox = null;

    public WikiTextParser(String string) {
        this.wikiText = string;
        Matcher matcher = redirectPattern.matcher(this.wikiText);
        if (matcher.find()) {
            this.redirect = true;
            if (matcher.groupCount() == 1) {
                this.redirectString = matcher.group(1);
            }
        }
        matcher = stubPattern.matcher(this.wikiText);
        this.stub = matcher.find();
        matcher = disambCatPattern.matcher(this.wikiText);
        this.disambiguation = matcher.find();
    }

    public boolean isRedirect() {
        return this.redirect;
    }

    public boolean isStub() {
        return this.stub;
    }

    public String getRedirectText() {
        return this.redirectString;
    }

    public String getText() {
        return this.wikiText;
    }

    public Vector<String> getCategories() {
        if (this.pageCats == null) {
            this.parseCategories();
        }
        return this.pageCats;
    }

    public Vector<String> getLinks() {
        if (this.pageLinks == null) {
            this.parseLinks();
        }
        return this.pageLinks;
    }

    private void parseCategories() {
        this.pageCats = new Vector();
        Pattern pattern = Pattern.compile("\\[\\[Category:(.*?)\\]\\]", 8);
        Matcher matcher = pattern.matcher(this.wikiText);
        while (matcher.find()) {
            String[] stringArray = matcher.group(1).split("\\|");
            this.pageCats.add(stringArray[0]);
        }
    }

    private void parseLinks() {
        this.pageLinks = new Vector();
        Pattern pattern = Pattern.compile("\\[\\[(.*?)\\]\\]", 8);
        Matcher matcher = pattern.matcher(this.wikiText);
        while (matcher.find()) {
            String string;
            String[] stringArray = matcher.group(1).split("\\|");
            if (stringArray == null || stringArray.length == 0 || (string = stringArray[0]).contains(":")) continue;
            this.pageLinks.add(string);
        }
    }

    public String getPlainText() {
        String string = this.wikiText.replaceAll("&gt;", ">");
        string = string.replaceAll("&lt;", "<");
        string = string.replaceAll("<ref>.*?</ref>", " ");
        string = string.replaceAll("</?.*?>", " ");
        string = string.replaceAll("\\{\\{.*?\\}\\}", " ");
        string = string.replaceAll("\\[\\[.*?:.*?\\]\\]", " ");
        string = string.replaceAll("\\[\\[(.*?)\\]\\]", "$1");
        string = string.replaceAll("\\s(.*?)\\|(\\w+\\s)", " $2");
        string = string.replaceAll("\\[.*?\\]", " ");
        string = string.replaceAll("\\'+", "");
        return string;
    }

    public InfoBox getInfoBox() {
        if (this.infoBox == null) {
            this.infoBox = this.parseInfoBox();
        }
        return this.infoBox;
    }

    private InfoBox parseInfoBox() {
        int n;
        String string = "{{Infobox";
        int n2 = this.wikiText.indexOf(string);
        if (n2 < 0) {
            return null;
        }
        int n3 = 2;
        for (n = n2 + string.length(); n < this.wikiText.length(); ++n) {
            switch (this.wikiText.charAt(n)) {
                case '}': {
                    --n3;
                    break;
                }
                case '{': {
                    ++n3;
                    break;
                }
            }
            if (n3 == 0) break;
        }
        String string2 = this.wikiText.substring(n2, n + 1);
        string2 = this.stripCite(string2);
        string2 = string2.replaceAll("&gt;", ">");
        string2 = string2.replaceAll("&lt;", "<");
        string2 = string2.replaceAll("<ref.*?>.*?</ref>", " ");
        string2 = string2.replaceAll("</?.*?>", " ");
        return new InfoBox(string2);
    }

    private String stripCite(String string) {
        int n;
        String string2 = "{{cite";
        int n2 = string.indexOf(string2);
        if (n2 < 0) {
            return string;
        }
        int n3 = 2;
        for (n = n2 + string2.length(); n < string.length(); ++n) {
            switch (string.charAt(n)) {
                case '}': {
                    --n3;
                    break;
                }
                case '{': {
                    ++n3;
                    break;
                }
            }
            if (n3 == 0) break;
        }
        string = string.substring(0, n2 - 1) + string.substring(n);
        return this.stripCite(string);
    }

    public boolean isDisambiguationPage() {
        return this.disambiguation;
    }

    public String getTranslatedTitle(String string) {
        Pattern pattern = Pattern.compile("^\\[\\[" + string + ":(.*?)\\]\\]$", 8);
        Matcher matcher = pattern.matcher(this.wikiText);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }
}

