/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.nlp.wikipedia;

import edu.jhu.nlp.wikipedia.IteratorHandler;
import edu.jhu.nlp.wikipedia.PageCallbackHandler;
import edu.jhu.nlp.wikipedia.SAXPageCallbackHandler;
import edu.jhu.nlp.wikipedia.WikiPageIterator;
import edu.jhu.nlp.wikipedia.WikiXMLParser;
import edu.jhu.nlp.wikipedia.WikiXMLParserFactory;
import java.io.InputStream;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class WikiXMLSAXParser
extends WikiXMLParser {
    private XMLReader xmlReader;
    private PageCallbackHandler pageHandler = null;

    public WikiXMLSAXParser(InputStream inputStream) {
        super(inputStream);
        this.initReaderHandler();
    }

    public WikiXMLSAXParser(String string) {
        super(string);
        this.initReaderHandler();
    }

    private void initReaderHandler() {
        try {
            this.xmlReader = XMLReaderFactory.createXMLReader();
            this.pageHandler = new IteratorHandler(this);
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
    }

    @Override
    public void setPageCallback(PageCallbackHandler pageCallbackHandler) throws Exception {
        this.pageHandler = pageCallbackHandler;
    }

    @Override
    public void parse() throws Exception {
        this.xmlReader.setContentHandler(new SAXPageCallbackHandler(this.pageHandler));
        this.xmlReader.parse(this.getInputSource());
    }

    @Override
    public WikiPageIterator getIterator() throws Exception {
        if (!(this.pageHandler instanceof IteratorHandler)) {
            throw new Exception("Custom page callback found. Will not iterate.");
        }
        throw new UnsupportedOperationException();
    }

    public static void parseWikipediaDump(String string, PageCallbackHandler pageCallbackHandler) throws Exception {
        WikiXMLParser wikiXMLParser = WikiXMLParserFactory.getSAXParser(string);
        wikiXMLParser.setPageCallback(pageCallbackHandler);
        wikiXMLParser.parse();
    }
}

