/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.nlp.wikipedia;

import edu.jhu.nlp.wikipedia.PageCallbackHandler;
import edu.jhu.nlp.wikipedia.WikiPage;
import edu.jhu.nlp.wikipedia.WikiPageIterator;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;
import org.apache.tools.bzip2.CBZip2InputStream;
import org.xml.sax.InputSource;

public abstract class WikiXMLParser {
    private String wikiXMLFile = null;
    private BufferedReader wikiXMLBufferedReader = null;
    protected WikiPage currentPage = null;

    public WikiXMLParser(String string) {
        this.wikiXMLFile = string;
    }

    public WikiXMLParser(InputStream inputStream) {
        this.wikiXMLBufferedReader = new BufferedReader(new InputStreamReader(inputStream));
    }

    public abstract void setPageCallback(PageCallbackHandler var1) throws Exception;

    public abstract void parse() throws Exception;

    public abstract WikiPageIterator getIterator() throws Exception;

    protected InputSource getInputSource() throws Exception {
        BufferedReader bufferedReader = null;
        if (this.wikiXMLBufferedReader != null) {
            bufferedReader = this.wikiXMLBufferedReader;
        } else if (this.wikiXMLFile.endsWith(".gz")) {
            bufferedReader = new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(this.wikiXMLFile))));
        } else if (this.wikiXMLFile.endsWith(".bz2")) {
            FileInputStream fileInputStream = new FileInputStream(this.wikiXMLFile);
            byte[] byArray = new byte[2];
            fileInputStream.read(byArray);
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new CBZip2InputStream((InputStream)fileInputStream)));
        } else {
            bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(this.wikiXMLFile)));
        }
        return new InputSource(bufferedReader);
    }

    protected void notifyPage(WikiPage wikiPage) {
        this.currentPage = wikiPage;
    }
}

