/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.nlp.wikipedia;

import edu.jhu.nlp.wikipedia.InfoBox;
import edu.jhu.nlp.wikipedia.WikiTextParser;
import java.util.Vector;

public class WikiPage {
    private String title = null;
    private WikiTextParser wikiTextParser = null;
    private String id = null;

    public void setTitle(String string) {
        this.title = string;
    }

    public void setWikiText(String string) {
        this.wikiTextParser = new WikiTextParser(string);
    }

    public String getTitle() {
        return this.title;
    }

    public String getTranslatedTitle(String string) {
        return this.wikiTextParser.getTranslatedTitle(string);
    }

    public boolean isDisambiguationPage() {
        return this.title.contains("(disambiguation)") || this.wikiTextParser.isDisambiguationPage();
    }

    public boolean isSpecialPage() {
        return this.title.contains(":");
    }

    public String getWikiText() {
        return this.wikiTextParser.getText();
    }

    public boolean isRedirect() {
        return this.wikiTextParser.isRedirect();
    }

    public boolean isStub() {
        return this.wikiTextParser.isStub();
    }

    public String getRedirectPage() {
        return this.wikiTextParser.getRedirectText();
    }

    public String getText() {
        return this.wikiTextParser.getPlainText();
    }

    public Vector<String> getCategories() {
        return this.wikiTextParser.getCategories();
    }

    public Vector<String> getLinks() {
        return this.wikiTextParser.getLinks();
    }

    public void setID(String string) {
        this.id = string;
    }

    public InfoBox getInfoBox() {
        return this.wikiTextParser.getInfoBox();
    }

    public String getID() {
        return this.id;
    }
}

