/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.nlp.wikipedia;

import edu.jhu.nlp.wikipedia.PageCallbackHandler;
import edu.jhu.nlp.wikipedia.WikiPage;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class SAXPageCallbackHandler
extends DefaultHandler {
    private PageCallbackHandler pageHandler;
    private WikiPage currentPage;
    private String currentTag;
    private StringBuilder currentWikitext;
    private StringBuilder currentTitle;
    private StringBuilder currentID;

    public SAXPageCallbackHandler(PageCallbackHandler pageCallbackHandler) {
        this.pageHandler = pageCallbackHandler;
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) {
        this.currentTag = string3;
        if (string3.equals("page")) {
            this.currentPage = new WikiPage();
            this.currentWikitext = new StringBuilder("");
            this.currentTitle = new StringBuilder("");
            this.currentID = new StringBuilder("");
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) {
        if (string3.equals("page")) {
            this.currentPage.setTitle(this.currentTitle.toString());
            this.currentPage.setID(this.currentID.toString());
            this.currentPage.setWikiText(this.currentWikitext.toString());
            this.pageHandler.process(this.currentPage);
        }
        if (string3.equals("mediawiki")) {
            // empty if block
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) {
        if (this.currentTag.equals("title")) {
            this.currentTitle = this.currentTitle.append(cArray, n, n2);
        } else if (this.currentTag.equals("id") && this.currentID.length() == 0) {
            this.currentID = new StringBuilder();
            this.currentID.append(cArray, n, n2);
        } else if (this.currentTag.equals("text")) {
            this.currentWikitext = this.currentWikitext.append(cArray, n, n2);
        }
    }
}

