/*
 * Decompiled with CFR 0.152.
 */
package edu.jhu.nlp.wikipedia;

import edu.jhu.nlp.wikipedia.PageCallbackHandler;
import edu.jhu.nlp.wikipedia.WikiPage;
import edu.jhu.nlp.wikipedia.WikiPageIterator;
import edu.jhu.nlp.wikipedia.WikiXMLParser;
import java.io.InputStream;
import java.util.Vector;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WikiXMLDOMParser
extends WikiXMLParser {
    private DOMParser domParser = new DOMParser();
    private static String FEATURE_URI = "http://apache.org/xml/features/dom/defer-node-expansion";
    private Vector<WikiPage> pageList = null;
    private PageCallbackHandler pageHandler = null;

    public WikiXMLDOMParser(String string) {
        super(string);
    }

    public WikiXMLDOMParser(InputStream inputStream) {
        super(inputStream);
    }

    @Override
    public void setPageCallback(PageCallbackHandler pageCallbackHandler) throws Exception {
        if (this.pageList != null) {
            throw new Exception("Set the callback before calling parse()");
        }
        this.pageHandler = pageCallbackHandler;
    }

    @Override
    public WikiPageIterator getIterator() throws Exception {
        if (this.pageHandler != null) {
            throw new Exception("page callback found. Cannot iterate.");
        }
        return new WikiPageIterator(this.pageList);
    }

    @Override
    public void parse() throws Exception {
        if (this.pageHandler == null) {
            this.pageList = new Vector();
        }
        this.domParser.setFeature(FEATURE_URI, true);
        this.domParser.parse(this.getInputSource());
        Document document = this.domParser.getDocument();
        NodeList nodeList = document.getElementsByTagName("page");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            WikiPage wikiPage = new WikiPage();
            Node node = nodeList.item(i);
            NodeList nodeList2 = node.getChildNodes();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Node node2 = nodeList2.item(j);
                if (node2.getNodeName().equals("title")) {
                    wikiPage.setTitle(node2.getFirstChild().getNodeValue());
                    continue;
                }
                if (node2.getNodeName().equals("id")) {
                    wikiPage.setID(node2.getFirstChild().getNodeValue());
                    continue;
                }
                if (!node2.getNodeName().equals("revision")) continue;
                NodeList nodeList3 = node2.getChildNodes();
                for (int k = 0; k < nodeList3.getLength(); ++k) {
                    Node node3 = nodeList3.item(k);
                    if (!node3.getNodeName().equals("text")) continue;
                    wikiPage.setWikiText(node3.getFirstChild().getNodeValue());
                }
            }
            if (this.pageHandler != null) {
                this.pageHandler.process(wikiPage);
                continue;
            }
            this.pageList.add(wikiPage);
        }
    }
}

